%Test Name: SquareSheetShelfTranSSA3dAggressiveRegionalOutput
md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md.geometry.bed=md.geometry.base;
pos=find(md.mask.groundedice_levelset<0);
md.geometry.bed(pos)=md.geometry.base(pos)-10;
md.friction=frictioncoulomb();
md.friction.coefficient=20.*ones(md.mesh.numberofvertices,1);
md.friction.p=ones(md.mesh.numberofelements,1);
md.friction.q=ones(md.mesh.numberofelements,1);
md.friction.coefficientcoulomb=0.02*ones(md.mesh.numberofvertices,1);
md.transient.isthermal=0;
md.transient.isgroundingline=1;
md.groundingline.migration='AggressiveMigration';

md.settings.output_frequency=2;
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',3);

regionalmask=zeros(md.mesh.numberofvertices,1);
in=ContourToMesh(md.mesh.elements,md.mesh.x,md.mesh.y,'../Exp/SquareHalfRight.exp','node',1);
regionalmask(find(in))=1;
md.transient.requested_outputs={'default','GroundedArea1','FloatingArea1','TotalFloatingBmb1','TotalGroundedBmb1','TotalSmb1',...
	'IceMass1','IceVolume1','IceVolumeAboveFloatation1','IceVolumeAboveFloatation2','IceVolumeAboveFloatation'};
md.outputdefinition.definitions{1}=regionaloutput('name','GroundedArea1','outputnamestring','GroundedArea','mask',regionalmask,...
	'definitionstring','Outputdefinition1');
md.outputdefinition.definitions{2}=regionaloutput('name','FloatingArea1','outputnamestring','FloatingArea','mask',regionalmask,...
	'definitionstring','Outputdefinition2');
md.outputdefinition.definitions{3}=regionaloutput('name','TotalFloatingBmb1','outputnamestring','TotalFloatingBmb','mask',regionalmask,...
	'definitionstring','Outputdefinition3');
md.outputdefinition.definitions{4}=regionaloutput('name','TotalGroundedBmb1','outputnamestring','TotalGroundedBmb','mask',regionalmask,...
	'definitionstring','Outputdefinition4');
md.outputdefinition.definitions{5}=regionaloutput('name','IceMass1','outputnamestring','IceMass','mask',regionalmask,...
	'definitionstring','Outputdefinition5');
md.outputdefinition.definitions{6}=regionaloutput('name','IceVolume1','outputnamestring','IceVolume','mask',regionalmask,...
	'definitionstring','Outputdefinition6');
md.outputdefinition.definitions{7}=regionaloutput('name','IceVolumeAboveFloatation1','outputnamestring','IceVolumeAboveFloatation','mask',regionalmask,...
	'definitionstring','Outputdefinition7');
md.outputdefinition.definitions{8}=regionaloutput('name','TotalSmb1','outputnamestring','TotalSmb','mask',regionalmask,...
	'definitionstring','Outputdefinition8');
md.outputdefinition.definitions{9}=regionaloutput('name','IceVolumeAboveFloatation2','outputnamestring','IceVolumeAboveFloatation',...
	'maskexpstring','../Exp/SquareHalfRight.exp','definitionstring','Outputdefinition9','model',md);

md=extrude(md,3,1);
md2=collapse(md);
md=solve(md,'Transient');

%Fields and tolerances to track changes
field_names     ={'IceMass1','IceVolume1','IceVolumeAboveFloatation1','IceVolumeAboveFloatation21',...
	'Thickness1','GroundedArea1','FloatingArea1','TotalFloatingBmb1','TotalGroundedBmb1','TotalSmb1',...
	'IceMass3','IceVolume3','IceVolumeAboveFloatation3','IceVolumeAboveFloatation23',...
	'Thickness3','GroundedArea3','FloatingArea3','TotalFloatingBmb3','TotalGroundedBmb3','TotalSmb3',...
	'ExtrudedMask','CollapsedMask'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	(md.results.TransientSolution(1).IceMass1),...
	(md.results.TransientSolution(1).IceVolume1),...
	(md.results.TransientSolution(1).IceVolumeAboveFloatation1),...
	(md.results.TransientSolution(1).IceVolumeAboveFloatation2),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).GroundedArea1),...
	(md.results.TransientSolution(1).FloatingArea1),...
	(md.results.TransientSolution(1).TotalFloatingBmb1),...
	(md.results.TransientSolution(1).TotalGroundedBmb1),...
	(md.results.TransientSolution(1).TotalSmb1),...
	(md.results.TransientSolution(3).IceMass1),...
	(md.results.TransientSolution(3).IceVolume1),...
	(md.results.TransientSolution(3).IceVolumeAboveFloatation1),...
	(md.results.TransientSolution(3).IceVolumeAboveFloatation2),...
	(md.results.TransientSolution(3).Thickness),...
	(md.results.TransientSolution(3).GroundedArea1),...
	(md.results.TransientSolution(3).FloatingArea1),...
	(md.results.TransientSolution(3).TotalFloatingBmb1),...
	(md.results.TransientSolution(3).TotalGroundedBmb1),...
	(md.results.TransientSolution(3).TotalSmb1),...
	length(md.outputdefinition.definitions{1}.mask),...
	length(md2.outputdefinition.definitions{1}.mask),...
	};
