#ifndef AMRBAMG
#define AMRBAMG

/*Includes*/
#include "../shared/shared.h"
#include "../toolkits/toolkits.h"

#include "../bamg/BamgMesh.h"
#include "../bamg/BamgGeom.h"
#include "../bamg/BamgOpts.h"

class AmrBamg{

	public:
		int fieldenum;

		/* Constructor, destructor etc*/
		AmrBamg(IssmDouble hmin, IssmDouble hmax,int fieldenum_in,IssmDouble err_in);
		~AmrBamg();

		/*General methods*/
		void Initialize(int* elements,IssmDouble* x,IssmDouble* y,int numberofvertices,int numberofelements);
		void ExecuteRefinementBamg(IssmDouble* field,int* pnewnumberofvertices,int *pnewnumberofelements,IssmDouble** px,IssmDouble** py,IssmDouble** pz,int** pelementslist);

	private:
		BamgGeom* geometry;
		BamgMesh* fathermesh;
		BamgMesh* previousmesh;
		BamgOpts* options;
};

#endif
