#ifndef ADAPTIVEMESHREFINEMENT
#define ADAPTIVEMESHREFINEMENT

/*Includes*/
/*{{{*/
/*Common includes*/
#include <iostream>
#include <fstream>
#include <string>

/*NeoPZ includes*/
/*REAL and STATE definitions, NeoPZ variables itapopo should be read by NeoPZ's config.h*/
#ifndef REFPATTERNDIR
	# define REFPATTERNDIR "/home/santos/trunk-jpl/externalpackages/neopz/install/include/refpatterns"
#endif

#ifndef REALdouble
	#define REALdouble
#endif

#ifndef STATEdouble
	#define STATEdouble
#endif

#include <pzreal.h>
#include <pzsave.h>
#include <pzgmesh.h>
#include <pzvec.h>
#include <pzeltype.h>

#include <TPZRefPatternTools.h>
#include <TPZRefPatternDataBase.h>
#include <TPZRefPattern.h>

#include <tpzchangeel.h>
#include <TPZGeoElement.h>
#include <pzreftriangle.h>
#include <tpzgeoelrefpattern.h>
/*}}}*/

class AdaptiveMeshRefinement : public TPZSaveable {

public:

	/*Public methods*/
	/* Constructor, destructor etc*/
	AdaptiveMeshRefinement();															
	AdaptiveMeshRefinement(const AdaptiveMeshRefinement &cp); 					
	AdaptiveMeshRefinement & operator= (const AdaptiveMeshRefinement &cp);	
	virtual ~AdaptiveMeshRefinement();												

    /*Savable methods*/
	virtual int ClassId() const;                                   
   virtual void Read(TPZStream &buf,void *context);							
   virtual void Write(TPZStream &buf,int withclassid);
    
	/*General methods*/
	void CleanUp();
	void Initialize();
	void SetLevelMax(int &h);
   void SetRegions(double &D1,double Dhmax);
	void SetElementWidth(int &width);
	void Execute(bool &amr_verbose,int &numberofelements,
						double* partiallyfloatedelements,double *masklevelset,double* deviatorictensorerror,double* thicknesserror,
						int &newnumberofvertices,int &newnumberofelements,double** x,double** y,int** elementslist);
	void CreateInitialMesh(int &nvertices,int &nelements,int &width,double* x,double* y,int* elements);
	TPZGeoMesh* CreateRefPatternMesh(TPZGeoMesh* gmesh);
	void CheckMesh(int &nvertices,int &nelements,int &width,double** px,double** py,int** pelements);

private:
	/*Private attributes*/
   int elementswidth;                                    // Geometric nodes for element: 3 == Tria, 4 == Tetra, 6 == Penta
   int levelmax;                                         // Max level of refinement
	double regionlevel1;												// Region which will be refined with level 1
	double regionlevelmax;											// Region which will be refined with level max
	std::vector<int> sid2index;									// Vector that keeps index of PZGeoMesh elements used in the ISSM mesh (sid) 
	TPZGeoMesh *fathermesh;											// Father Mesh is the entire mesh without refinement
	TPZGeoMesh *currentmesh;										// Current Mesh is the refined mesh

	/*Private methods*/
   void RefinementProcess(bool &amr_verbose,double* partiallyfloatedelements,double* masklevelset,double* deviatorictensorerror,double* thicknesserror);
	void RefineMesh(TPZGeoMesh *gmesh,std::vector<int> &elements); 
   void RefineMeshToAvoidHangingNodes(TPZGeoMesh *gmesh);
	void GetMesh(int &nvertices,int &nelements,double** px,double** py,int** pelements);
	void FindElements(int &numberofpoints,double* xp,double* yp,TPZGeoMesh *gmesh,int &hlevel,std::vector<int> &elements);
   void AllElements(TPZGeoMesh *gmesh,std::vector<int> &elements);
   inline int GetElemMaterialID(){return 1;}          
};

#endif
