%AMRBAMG Class definition
%
%   Usage:
%      amrbamg=amrbamg();

classdef amrbamg
	properties (SetAccess=public) 
		hmin = 0.; 
		hmax = 0.;
		fieldname = '';
		err = 0.;
	end
	methods
		function self = amrbamg(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = setdefaultparameters(self) % {{{

			%hmin and hmax
			self.hmin=100.;
			self.hmax=100.e3;

			%fields
			self.fieldname ='Vel';
			self.err=3.;

		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			md = checkfield(md,'fieldname','amr.hmax','numel',[1],'>',0,'NaN',1);
			md = checkfield(md,'fieldname','amr.hmin','numel',[1],'>',0,'<',self.hmax,'NaN',1);
			%md = checkfield(md,'fieldname','amr.fieldname','string',[1]);
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   amrbamg parameters:'));

			fielddisplay(self,'hmin',['minimum element length']);
			fielddisplay(self,'hmax',['maximum element length']);
			fielddisplay(self,'fieldname',['name of input that will be used to compute the metric (should be an input of FemModel)']);

		end % }}}
		function marshall(self,prefix,md,fid) % {{{

			WriteData(fid,prefix,'name','md.amr.type','data',1,'format','Integer');
			WriteData(fid,prefix,'object',self,'class','amr','fieldname','hmin','format','Double');
			WriteData(fid,prefix,'object',self,'class','amr','fieldname','hmax','format','Double');
			WriteData(fid,prefix,'object',self,'class','amr','fieldname','fieldname','format','String');
			WriteData(fid,prefix,'object',self,'class','err','fieldname','err','format','Double');

		end % }}}
	end
end
