function plot_overlay(md, data, options, canvas){ //{{{
	//PLOT_OVERLAY - Function for plotting a georeferenced image.  
	//
	//   Usage:
	//      plot_overlay(md, data, options, canvas);
	//
	//   See also: PLOTMODEL, PLOT_MANAGER

	if ('overlay' in  canvas.nodes && options.getfieldvalue('cachenodes','on') === 'on') return;
	
	//{{{ declare variables:
	//Process data and model
	var meshresults = processmesh(md, [], options);
	var x = meshresults[0]; 
	var y = meshresults[1]; 
	var z = meshresults[2]; 
	var elements = meshresults[3]; 
	var is2d = meshresults[4]; 
	var isplanet = meshresults[5];
	if (md.mesh.classname() !== 'mesh3dsurface') z = md.geometry.surface;
	
	//Compute coordinates and data range:
	var xlim = options.getfieldvalue('xlim', [ArrayMin(x), ArrayMax(x)]);
	var ylim = options.getfieldvalue('ylim', [ArrayMin(y), ArrayMax(y)]);
	var zlim = options.getfieldvalue('zlim', [ArrayMin(md.geometry.surface), ArrayMax(md.geometry.surface)]);
	
	//Handle radaroverlay
	if (md.radaroverlay.outerx) {
		var result = Node.prototype.mergeVertices(x, y, z, elements, md.radaroverlay.outerx, md.radaroverlay.outery, md.radaroverlay.outerheight, md.radaroverlay.outerindex);
		x = result.x;
		y = result.y;
		z = result.z;
		elements = result.elements;
	}
	
	//Handle heightscale
	var vertices, scale;
	if (md.mesh.classname() !== 'mesh3dsurface') {
		vertices = [x, y, z];
		scale = [1, 1, options.getfieldvalue('heightscale', 1)];
	}
	else {
		vertices = Node.prototype.scaleVertices(md, x, y, z, options.getfieldvalue('heightscale', 1));
		scale = [1, 1, 1];
	}
	
	//Compute gl variables:
	var edgecolor = options.getfieldvalue('edgecolor', 'black');
	var texture = initTexture(gl, options.getfieldvalue('overlay_image'));
	var node = new Node(
		'canvas', canvas,
		'options', options,
		'name', 'overlay',
		'shaderName', 'ground' in options.getfieldvalue('render', {}) ? 'GroundFromSpace' : 'Textured',
		'alpha', options.getfieldvalue('outeralpha', 1.0),
		//'center', [(xlim[0] + xlim[1]) / 2, (ylim[0] + ylim[1]) / 2, md.mesh.classname() === 'mesh3dsurface' ? (zlim[0] + zlim[1]) / 2 : zlim[0]],
		'center', [(xlim[0] + xlim[1]) / 2, (ylim[0] + ylim[1]) / 2, (zlim[0] + zlim[1]) / 2],
		'diffuseColor', 'white',
		'maskEnabled', options.getfieldvalue('outermask','off') == 'on',
		'maskHeight', options.getfieldvalue('outermaskheight', 150.0),
		'maskColor', options.getfieldvalue('outermaskcolor',[0.0, 0.0, 1.0, 1.0]),
		'texture', texture,
		'rotation', [-90, 0, 0],
		'scale', scale
	);
	//}}}
	
	var xRange = xlim[1] - xlim[0];
	var yRange = ylim[1] - ylim[0];
	var coordArray = [new Array(x.length), new Array(x.length)];
	//generate mesh:
	
	if (md.mesh.classname() == 'mesh3dsurface') {
		var xyz, magnitude;
		for(var i = 0; i < x.length; i++){
			xyz = vec3.fromValues(vertices[0][i], vertices[1][i], vertices[2][i]);
			magnitude = vec3.length(xyz);
		
			coordArray[0][i] = Math.atan2(xyz[1], xyz[0]) / (2 * Math.PI) + 0.5;
			coordArray[1][i] = Math.asin(xyz[2] / magnitude) / Math.PI + 0.5;
		}
	}
	else {
		for(var i = 0; i < x.length; i++){
			coordArray[0][i] = (vertices[0][i] - xlim[0]) / xRange;
			coordArray[1][i] = (vertices[1][i] - ylim[0]) / yRange;
		}
	}
	node.patch('Faces', elements, 'Vertices', vertices, 'FaceVertexCData', coordArray, 'FaceColor', 'interp', 'EdgeColor', edgecolor);
} //}}}
