import numpy as np
from project3d import project3d
from fielddisplay import fielddisplay
from checkfield import checkfield
from WriteData import WriteData


class frictionhydro(object):
	"""
	FRICTIONWEERTMAN class definition

	Usage:
		friction=frictionhydro();
	"""
	def __init__(self): # {{{
		self.coupling  		  		= 0
		self.q    				= float('NaN')
		self.C    				= float('NaN')
		self.As    				= float('NaN')
		self.effective_pressure			= float('NaN')
		#set defaults
		self.setdefaultparameters()
	#}}}

		#what is this:
		#function self = frictionhydro(varargin) % {{{
		#	switch nargin
		#		case 0
		#			self=setdefaultparameters(self);
		#		otherwise
		#			error('constructor not supported');
		#	end
		#end % }}}
		
	def checkconsistency(self,md,solution,analyses): #{{{ 

		#Early return
		if 'StressbalanceAnalysis' in analyses and 'ThermalAnalysis' in analyses:
			return md
		
		md = checkfield(md,'fieldname','friction.coupling','numel',[1],'values',[0,1,2])
		md = checkfield(md,'fieldname','friction.q','NaN',1,'Inf',1,'size',[md.mesh.numberofelements,1])
		md = checkfield(md,'fieldname','friction.C','NaN',1,'Inf',1,'size',[md.mesh.numberofelements,1])
		md = checkfield(md,'fieldname','friction.As','NaN',1,'Inf',1,'size',[md.mesh.numberofelements,1])
		if self.coupling==1:
			md = checkfield(md,'fieldname','friction.effective_pressure','NaN',1,'Inf',1,'timeseries',1)
		elif self.coupling==2:
			raise ValueError('coupling not supported yet')
		elif self.coupling > 2:
			raise ValueError('md.friction.coupling larger than 2, not supported yet')
	# }}}

	def extrude(self,md): # {{{
		self.q=project3d(md,'vector',self.q,'type','element')
		self.C=project3d(md,'vector',self.C,'type','element')
		self.As=project3d(md,'vector',self.As,'type','element')
		if self.coupling==1:
			self.effective_pressure=project3d(md,'vector',self.effective_pressure,'type','node','layer',1)
		elif self.coupling==2:
			raise ValueError('coupling not supported yet')
		elif self.coupling > 2:
			raise ValueError('md.friction.coupling larger than 2, not supported yet')		
		return self	
	 # }}} 


	def __repr__(self): # {{{
		string='Effective Pressure based friction law described in Gagliardini 2007'
		string="%s\n%s"%(string,fielddisplay(self,'coupling','Coupling flag: 0 for default, 1 for forcing(provide md.friction.effective_pressure)  and 2 for coupled(not implemented yet)'))
		string="%s\n%s"%(string,fielddisplay(self,'q','friction law exponent q>=1'))
		string="%s\n%s"%(string,fielddisplay(self,'C','friction law max value [SI]'))
		string="%s\n%s"%(string,fielddisplay(self,'As','Sliding Parameter without cavitation [m Pa^-n s^-1]'))
		string="%s\n%s"%(string,fielddisplay(self,'effective_pressure','Effective Pressure for the forcing if not coupled [Pa]'))

		return string
	#}}}


	def marshall(self,prefix,md,fid): #{{{
		WriteData(fid,prefix,'name','md.friction.law','data',3,'format','Integer')
		WriteData(fid,prefix,'class','friction','object',self,'fieldname','coupling','format','Integer')
		WriteData(fid,prefix,'class','friction','object',self,'fieldname','q','format','DoubleMat','mattype',2)
		WriteData(fid,prefix,'class','friction','object',self,'fieldname','C','format','DoubleMat','mattype',2)
		WriteData(fid,prefix,'class','friction','object',self,'fieldname','As','format','DoubleMat','mattype',2)
		if self.coupling==1:
			WriteData(fid,prefix,'class','friction','object',self,'fieldname','effective_pressure','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts)
		elif self.coupling==2:
			raise ValueError('coupling not supported yet')
		elif self.coupling > 2:
			raise ValueError('md.friction.coupling larger than 2, not supported yet')
	#}}}


