function varargout=runme(varargin)
%RUNME - test deck for ISSM nightly runs
%
%   Usage:
%      varargout=runme(varargin);
%
%   Examples:
%      runme;
%      runme('analysis_type',{'prognostic','diagnostic'});
%      runme('analysis_type',{'prognostic','diagnostic'},'parallel',0);
%      runme('analysis_type',{'prognostic','diagnostic'},'parallel',1);
%
%   See Also: NIGHTLYRUN UPDATEARCHIVE

% This file can be run to check that the current version of issm is giving 
% coherent results.
% The results of this test will indicate if there is a difference between current computations 
% and archived results.

% Errors  between archived results and the current version will get flagged if they are not within 
% a certain tolerance. 

%check arguments
if nargout>1
	help runme
	error('runme error message: bad usage');
end

%call runme_core
md=runme_core('procedure','check',varargin{:});

%output model md if requested
if nargout==1, 
	varargout{1}=md; 
end
