function options=recover_options(varargin)
%RECOVER_OPTIONS - recover options from a list of inputs
%
%   Usage:
%      options=recover_solve_options(varargin);
%
%   See also: RECOVER_PLOT_OPTIONS, MESHYAMS,SOLVE

%initialize options.
options=cell(0,2);

%make sure length(varargin) is even, ie options come in pairs.
if mod(length(varargin),2),
	error('recover_options error message: an even number of options is necessary');
end

%go through varargin, extract options 
for i=1:length(varargin)/2,

	options(end+1,:)={varargin{2*i-1} varargin{2*i}};

end
