function  value=find_option(options,field)
%FINDARG - find argument associated to a field in a list
%
%   This function parses through an argument list (typically varargin in a routine)
%   looking for a character array equal to field. Once this is found, we return the 
%   next value in the varargin (if possible). 
%   Because field might appear several times in the argument list, we return a structure 
%   holding all these values. 
%   Note that all comparisons to field value are case independent.
%
%   Usage:
%      vals=find_option(options,field)
%
%   See also: RECOVER_OPTIONS

%some argument checking: 
if ((nargin~=2) | (nargout~=1)),
	help find_option;
	error('find_option error message');
end

if ~ischar(field),
	error('find_option error message: field should be a string');
end

if ~iscell(options),
	error('find_option error message: argument list should be a cell array.');
end

if mod(size(options,2),2),
	error('find_option error message: options should be a cell of 2 columns')
end

%Recover option
value=[];
for i=1:size(options,1),
	if strcmpi(options{i,1},field)
		value=options{i,2};
		return
	end
end
