function varargout=updatearchive(varargin)
%UPDATEARCHIVE - update test deck for ISSM nightly runs
%
%   Usage:
%      varargout=updatearchive(varargin);
%
%   Examples:
%      updatearchive;
%      updatearchive('analysis_type',{'prognostic','diagnostic'});
%      updatearchive('analysis_type',{'prognostic','diagnostic'},'parallel',0);
%      updatearchive('analysis_type',{'prognostic','diagnostic'},'parallel',1);
%
%   See Also: NIGHTLYRUN RUNME

% This file can be run to update that the current version of issm is giving 
% coherent results. 
% Just run this file in Matlab, with a properly setup ISSM code. 
% The results of this test will indicate if there is a difference between current computations 
% and archived results.

%check arguments
if nargout>1
	help updatearchive
	error('updatearchive error message: bad usage');
end

%call updatearchive_core
md=runme_core('procedure','update',varargin{:});

%output model md if requested
if nargout==1, 
	varargout{1}=md; 
end
