
/*
	PenpairLoad.h
*/

/*
	PenpairLoad is derived from the basic Penpair, which holds one penalty 
	pair, for 2 grids, for a certain dof. PenpairLoad adds load-level functionality 
	to the object.

	See PenpairLoad.c for more explanations.
*/


#ifndef _PENPAIRLOAD_H
#define _PENPAIRLOAD_H


#include "./PenpairLoad.h"

#include "../InternalGrid.h"

/* element matrices: */
#include "../objects.h"




typedef struct {

	Penpair penpair;
	
	/* "friend" class object pointers and indices: */
	int				internalgrid_indices[2];	/* DataSet indices into partition grids dataset...             */
	int				internalgrid_indicesb[2];	/* DataSet indices into boundary partition grids dataset...             */
	InternalGrid*	pg[2];						/* ... and object pointers        */

	int             active;
	int             counter;
	int             prestable;

	int             internalelement_indices[2]; /* points to elements holding this penalty pair.*/
	void*           elements[2];


} PenpairLoad;


/* creation, initialisation: */

	PenpairLoad*	NewPenpairLoad( void* vppenpair);	/* cast to Penpair */

	/* "virtual" functions, used or required by DataSet: */

	void  DeletePenpairLoad( void* *vpthis);	/* void*'s only for compatibility */
	void  PenpairLoadEcho( void* vpthis );
	int   PenpairLoadSizeOfInDoubles( void* vpthis);
	void  PenpairLoadShrinkWrap( void* to, void* vpthis);
	int   PenpairLoadUnwrap( void* vpthis);
	void  PenpairLoadMarshall( char* *pbuffer, void* vpthis, int* size);
	void* PenpairLoadDemarshall( DataSet* ds, char* *pbuffer, int machine_flag); 
	int   PenpairLoadGetID( void* this);
	int   PenpairLoadSetVirtualFunctions( void* vf);


/* other "virtual" functions: */

	/* general: */

	char*   PenpairLoadGetName( void* vpthis);
	int     PenpairLoadConfigure( void* vpthis, int num_datasets, ...);
	
	int PenpairLoadAddToDataSet( DataSet* dataset, PenpairLoad* this);
	
	/* load functionality: */
	int PenpairLoadPenaltyCreateKMatrix( ElemMatrix* *pKe_gg, void* vpthis, ParameterInputs* inptus, int K_flag, double kmax, int analysis_type);
	int PenpairLoadPenaltyCreateKMatrixOneDof( ElemMatrix* *pKe_gg, void* vpthis, ParameterInputs* inptus, int K_flag, double kmax, int analysis_type);
	int PenpairLoadPenaltyCreateKMatrixTwoDof( ElemMatrix* *pKe_gg, void* vpthis, ParameterInputs* inputs, int K_flag, double kmax, int analysis_type);
	int PenpairLoadPenaltyConstrain(int* punstable, void* vpthis,ParameterInputs* inputs, int analysis_type);
	int PenpairLoadPenaltyCreatePVector( ElemVector* *ppe_g, void* vpthis, ParameterInputs* inputs, double kmax, int analysis_type);
	int PenpairLoadPenaltyCreatePVectorTwoDof( ElemVector* *ppe_g, void* vpthis, ParameterInputs* inputs, double kmax, int analysis_type);
	int PenpairLoadPenetration(double* ppenetration, void* vpthis,ParameterInputs* inputs, int analysis_type);
	int PenpairLoadPenaltyPreConstrain(int* punstable, void* vpthis,ParameterInputs* inputs, int analysis_type);
	int PenpairLoadPotentialUnstableConstraint(int* punstable, void* vpthis,ParameterInputs* inputs, int analysis_type);

#endif  

