
/*
	IcefrontLoad.h
*/

/*
	IcefrontLoad is derived from the basic object Icefront. Icefront holds all the info
	necessary to apply boundary conditions at the icefront (dynamic pressure condition 
	if running diagnostic, free radiation if running prognostic, etc ...). 
	IcefrontLoad adds load-level functionality to the Icefront object.

	See IcefrontLoad.c for more explanations.
*/


#ifndef _ICEFRONTLOAD_H
#define _ICEFRONTLOAD_H


#include "../Icefront.h"
#include "../InternalGrid.h"

#include "../objects.h"


typedef struct {

	Icefront icefront;

	char	name[LARGEFIELDWIDTH+1];

	int		internalgrid_indices[MAX_ICEFRONT_GRIDS];	/* DataSet indices into partition grids dataset*/

	int		internalgrid_indicesb[MAX_ICEFRONT_GRIDS];	/* DataSet indices into boundary partition grids dataset*/

	InternalGrid*	pg[MAX_ICEFRONT_GRIDS];	 /* pointers to internal grid objects in grids datasets */

	int     element_index;
	int     element_enum;
	void*   element;

	int     matpar_index;
	int     matpar_enum;      
	void*   matpar; 

} IcefrontLoad;

/* creation, initialisation: */

	IcefrontLoad*	NewIcefrontLoad( void* vpicefront);	/* cast to Icefront */

	/* "virtual" functions, used or required by DataSet: */

	void  DeleteIcefrontLoad( void* *vpthis);	/* void*'s only for compatibility */
	void  IcefrontLoadEcho( void* vpthis );
	int   IcefrontLoadSizeOfInDoubles( void* vpthis);
	void  IcefrontLoadShrinkWrap( void* to, void* vpthis);
	int   IcefrontLoadUnwrap( void* vpthis);
	void  IcefrontLoadMarshall( char* *pbuffer, void* vpthis, int* size);
	void* IcefrontLoadDemarshall( DataSet* ds, char* *pbuffer, int machine_flag); 
	int   IcefrontLoadGetID( void* this);
	int   IcefrontLoadGetElementID( void* this);
	int   IcefrontLoadSetVirtualFunctions( void* vf);


/* other "virtual" functions: */

	/* general: */

	int     IcefrontLoadConfigure( void* vpthis, int num_datasets, ...);
	
	char*   IcefrontLoadGetName( void* vpthis);

	int IcefrontLoadAddToDataSet( DataSet* dataset, IcefrontLoad* this);

	/* loads vector creation: */
	int IcefrontLoadCreatePVector( ElemVector* *ppe_g, void* vpthis, ParameterInputs* inputs, int analysis_type);
	int IcefrontLoadDiagnosticCreatePVector( ElemVector* *ppe_g, void* vpthis, ParameterInputs* inputs, int analysis_type);
	int IcefrontLoadCreatePVectorDiagnosticHoriz( ElemVector* *ppe_g, void* vpthis, ParameterInputs* inputs);
	int IcefrontLoadCreatePVectorDiagnosticHorizSegment( ElemVector* *ppe_g, void* vpthis, ParameterInputs* inputs);
	int IcefrontLoadCreatePVectorDiagnosticHorizQuad( ElemVector* *ppe_g, void* vpthis, ParameterInputs* inputs);
	int IcefrontLoadPrognosticCreatePVector( ElemVector* *ppe_g, void* vpthis, ParameterInputs* inputs, int analysis_type);

	/* some shared functionality: */
	int SegmentPressureLoad(ElemVector* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, double* normal,double lenght,int fill);
	int QuadPressureLoad(ElemVector* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, 
		                              double* normal1,double* normal2,double* normal3,double* normal4,double* xyz_list, int fill,int eid);
	
#endif  

