/*
 * Matice.h
 */


#ifndef _MATICE_H
#define _MATICE_H


/* "friend" functionality: */
#include "../DataSet/DataSet.h"

/* input file-specific defines: */  
#include "./InputFormats.h"

typedef struct {
	char	name[LARGEFIELDWIDTH+1];
	int		mid;
	double  B;
	double  n;
} Matice;


/* creation, initialisation: */

	Matice*	NewMatice(void);
	int     MaticeInit(Matice* this);


/* "virtual functions", used or required by DataSet: */

	void  DeleteMatice( void* *vpthis);		/* void*'s only for compatibility */
	void  MaticeEcho( void* vpthis);
	int   MaticeSizeOfInDoubles( void* vpthis);
	void  MaticeShrinkWrap( void* to, void* vpthis);
	int   MaticeUnwrap( void* vpthis);
	void  MaticeMarshall( char* *pbuffer, void* vpthis, int* size);
	void* MaticeDemarshall( DataSet* ds, char* *pbuffer, int machine_flag); 
	int   MaticeGetID( void* this);
	int   MaticeSetVirtualFunctions( void* vf);


/* other member functions: */

	/* alternative interface to DataSetAddObject */
	int MaticeAddToDataSet( DataSet* dataset, Matice* this);
	int MaticeGetViscosity2d(double* pmu, void* vpthis, double* epsilon);
	int MaticeGetViscosity3d(double* pmu, void* vpthis, double* epsilon);
	int MaticeSetFlowLawParameter(void* vpthis,double B_value);
	int MaticeGetViscosity2(double* pmu2, void* vpthis, double* epsilon);

/* other "virtual" functions: */

	/* general: */

	char* MaticeGetName( void* vpthis);


#endif  /* _MATICE_H */

