function nightlyrun(varargin)
%NIGHTLYRUN - run the nighlty tests on 'tests/Verification'
%
%   This function goes to each directory of 'tests/Verifications' and
%   launch the nightly tests. A specific package can be given in input
%   only this package will be tested
%   if last arguments are a pair of numbers, they represent the node rank and the number of 
%   cpus being used for the nightly run.
%
%  Usage:
%      nightlyrun(varargin)
%
%   Example:
%      nightlyrun;
%      nightlyrun({'ice'});
%      nightlyrun({'cielo_serial','cielo_parallel'});
%      nightlyrun({'ice'},{'prognostic','diagnostic'});
%      nightlyrun({'ice'},{'prognostic','diagnostic'},1,3);

%use ISSM_DIR generated by startup.m
global ISSM_DIR

%recover options
options=recover_options(varargin{:});

%check numproc and rank options
rank=find_option(options,'rank');
if isempty(rank), rank=1; end
rank=find_option(options,'numproc');
if isempty(rank), numproc=1; end

%Go to Test directory
eval(['cd ' ISSM_DIR '/test/']);

%Run all verification tests
cd Verification

list=listfilesparallel(rank,numprocs);

%Go through list of decks, and run the deck runme.m files
for j=1:numel(list),
	eval(['cd ' list{j}]);
	runme(varargin{:});
	cd ..
end

%display needed by nightlyrun.sh to check that no error popped up.
disp('NIGHTLYRUNTERMINATEDCORRECTLY');
