#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.7.2 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-lite-3.7.2.tar.gz' 'petsc-3.7.2.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.7.2.tar.gz
mv petsc-3.7.2/* src/
rm -rf petsc-3.7.2

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-cc=icc --with-cxx=icpc --with-fc=ifort --with-f77=ifort \
	--with-blas-lapack-dir="/nasa/intel/Compiler/2016.2.181/compilers_and_libraries_2016.2.181/linux/mkl/" \
	--known-mpi-shared-libraries=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch=1  \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-mumps=1 \
	--download-scalapack=1 \
	--download-ml=1 \
	--download-pastix=1 \
	--download-ptscotch=1 \
	--download-hypre=1 \
	--download-euclid=1 \
	--download-spooles=1 \
	--download-spai=1 \
	--download-superlu_dist=1 \
	--download-scalapack=1 

#prepare script to reconfigure petsc
cat > script.queue << EOF
#PBS -S /bin/bash
#PBS -l select=1:ncpus=1:model=bro
#PBS -l walltime=200 
#PBS -W group_list=s1690
#PBS -m e 

. /usr/share/modules/init/bash 
module load comp-intel/2016.2.181
module load mpi-sgi/mpt

export PATH="$PATH:." 
export MPI_GROUP_MAX=64 
mpiexec -np 1 ./conftest-arch-linux2-c-opt
EOF

#print instructions
echo "== Now: cd src/ "
echo "== qsub -q devel script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
