function varargout = mdanalysis(varargin)
global md logvalue
% MDANALYSIS MATLAB code for mdanalysis.fig
%      MDANALYSIS, by itself, creates a new MDANALYSIS or raises the existing
%      singleton*.
%
%      H = MDANALYSIS returns the handle to a new MDANALYSIS or the handle to
%      the existing singleton*.
%
%      MDANALYSIS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MDANALYSIS.M with the given input arguments.
%
%      MDANALYSIS('Property','Value',...) creates a new MDANALYSIS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before mdanalysis_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to mdanalysis_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES
%variables: 
logvalue=0;

%retreive model first: 
vars = evalin('base','who');
for i=1:length(vars),
	var=vars{i};
	classtype=evalin('base',['class(' var ');']);
	if strcmpi(classtype,'model'),
		md=evalin('base',var);
	end
end

% Edit the above text to modify the response to help mdanalysis

% Last Modified by GUIDE v2.5 26-Nov-2016 15:32:15

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @mdanalysis_OpeningFcn, ...
                   'gui_OutputFcn',  @mdanalysis_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before mdanalysis is made visible.
function mdanalysis_OpeningFcn(hObject, eventdata, handles, varargin)
global md
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to mdanalysis (see VARARGIN)

% Choose default command line output for mdanalysis
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% This sets up the initial plot - only do when we are invisible
% so window can get raised using mdanalysis.
if strcmp(get(hObject,'Visible'),'off')
	plotm();
end


% UIWAIT makes mdanalysis wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = mdanalysis_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over Interp.
function Interp_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to Interp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over Faceted.
function Faceted_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to Faceted (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over Flat.
function Flat_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to Flat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


function plotv()
	vars = evalin('base','who');
	for i=1:length(vars),
		var=vars{i}; 
		classtype=evalin('base',['class(' var ');']); 
		if strcmpi(classtype,'model'),
			md=evalin('base',var);
		end
	end

	if strcmpi(class(md),'model'),
		%field:  % {{{ 
		fieldHandle=findobj('Tag', 'Field'); 
		fieldstrings=get(fieldHandle,'String');
		fieldvalue=get(fieldHandle,'Value');
		field=fieldstrings{fieldvalue};
		vols=resultstomatrix(md,'TransientSolution',field);
		%}}}
	end
		
	cla;
	plot(vols(2,:),vols(1,:)/1e12);
	xlabel('time (yr)');
	ylabel('Mass (Gt)');
	axis square;


function plotm()
global logvalue

	vars = evalin('base','who');
	for i=1:length(vars),
		var=vars{i}; 
		classtype=evalin('base',['class(' var ');']); 
		if strcmpi(classtype,'model'),
			md=evalin('base',var);
		end
	end

	if strcmpi(class(md),'model'),
		%counter:  % {{{ 
		stepHandle=findobj('Tag', 'Step'); 
		stepstrings=get(stepHandle,'String');
		stepvalue=get(stepHandle,'Value');
		stepstring=stepstrings{stepvalue};
		%grab second integer: 
		A=sscanf(stepstring,'%g (%i)'); counter=A(2);
		%}}}
		%log:  % {{{ 
		logHandle=findobj('Tag', 'Log'); logvalue=get(logHandle,'Value');
		%}}}
		%shading:  %{{{
		interpHandle=findobj('Tag', 'Interp'); interpvalue=get(interpHandle,'Value');
		flatHandle=findobj('Tag', 'Flat'); flatvalue=get(flatHandle,'Value');
		facetedHandle=findobj('Tag', 'Faceted'); facetedvalue=get(facetedHandle,'Value');
		if interpvalue,
			shadingv='interp';
		elseif flatvalue,
			shadingv='flat';
		elseif facetedvalue,
			shadingv='faceted';
		else 
			shadingv='interp';
		end
		%}}}
		%mask:  %{{{
		groundedHandle=findobj('Tag', 'Grounded'); groundedvalue=get(groundedHandle,'Value');
		iceHandle=findobj('Tag', 'Ice'); icevalue=get(iceHandle,'Value');
		oceanHandle=findobj('Tag', 'Ocean'); oceanvalue=get(oceanHandle,'Value');
		if groundedvalue, maskv=md.mask.groundedice_levelset>=0 & md.mask.ice_levelset<=0; end;
		if icevalue, maskv=md.mask.ice_levelset<=0; end;
		if oceanvalue, maskv=ones(md.mesh.numberofvertices,1); end;
		%}}}
		%lock limits:  % {{{
		lockHandle=findobj('Tag', 'Lock'); lockvalue=get(lockHandle,'Value');
		if lockvalue,
			xl=xlim; yl=ylim;
		else
			xl=[min(md.mesh.x) max(md.mesh.x)];
			yl=[min(md.mesh.y) max(md.mesh.y)];
		end %}}}
		%color limits:  % {{{
		cminHandle=findobj('Tag','Cmin'); cmin=str2num(get(cminHandle,'String'));
		cmaxHandle=findobj('Tag','Cmax'); cmax=str2num(get(cmaxHandle,'String'));
		if isnan(cmin) | isnan(cmax),
			if logvalue,
				colaxis=[.1 max(md.results.TransientSolution(counter).Vel) ];
			else
				colaxis=[min(md.results.TransientSolution(counter).Vel) max(md.results.TransientSolution(counter).Vel) ];
			end
		else 
			colaxis=[cmin,cmax];
		end %}}}
		%time: {{{	
		timeHandle=findobj('Tag','Time');
		set(timeHandle,'String',sprintf('%4.2f',md.results.TransientSolution(counter).time));
		%}}}
		%diffcounter:  % {{{ 
		stepHandle=findobj('Tag', 'DiffStep'); 
		stepstrings=get(stepHandle,'String');
		stepvalue=get(stepHandle,'Value');
		stepstring=stepstrings{stepvalue};
		%grab second integer: 
		A=sscanf(stepstring,'%g (%i)'); diffcounter=A(2);
		diffHandle=findobj('Tag', 'Diff'); 
		diff=get(diffHandle,'Value');
		%}}}
		%field:  % {{{ 
		fieldHandle=findobj('Tag', 'Field'); 
		fieldstrings=get(fieldHandle,'String');
		fieldvalue=get(fieldHandle,'Value');
		fieldv=fieldstrings{fieldvalue};
		field=md.results.TransientSolution(counter).(fieldv);
		dfield=md.results.TransientSolution(diffcounter).(fieldv);
		%}}}
		%model field? : {{{ 
		mfHandle=findobj('Tag', 'Mf'); 
		mf=get(mfHandle,'Value');
		if (mf),
			fieldHandle=findobj('Tag', 'ModelFields'); 
			fieldstrings=get(fieldHandle,'String');
			fieldvalue=get(fieldHandle,'Value');
			fieldv=fieldstrings{fieldvalue};
			eval(['field=' fieldv ';']);
		end
		%}}}
	
		cla;
		if logvalue,
			plotmodel(md,'data',field,'figurestatement','off','clf','off','mask',maskv,'caxis',colaxis,'log',10,'xlim',xl,'ylim',yl,'shading',shadingv);
		else
			if ~diff,
				plotmodel(md,'data',field,'figurestatement','off','clf','off','mask',maskv,'caxis',colaxis,'xlim',xl,'ylim',yl,'shading',shadingv);
			else
				plotmodel(md,'data',dfield-field,'figurestatement','off','clf','off','mask',maskv,'caxis',colaxis,'xlim',xl,'ylim',yl,'shading',shadingv);
			end

		end
	else
		error('no available model!');
	end


% --- Executes on button press in Interp.
function Interp_Callback(hObject, eventdata, handles)
% hObject    handle to Interp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();
% Hint: get(hObject,'Value') returns toggle state of Interp


% --- Executes on button press in Faceted.
function Faceted_Callback(hObject, eventdata, handles)
% hObject    handle to Faceted (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();
% Hint: get(hObject,'Value') returns toggle state of Faceted


% --- Executes on button press in Flat.
function Flat_Callback(hObject, eventdata, handles)
% hObject    handle to Flat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();
% Hint: get(hObject,'Value') returns toggle state of Flat



% --- Executes on selection change in Step.
function Step_Callback(hObject, eventdata, handles)
global grounded ice  logvalue
% hObject    handle to Step (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();

% Hints: contents = cellstr(get(hObject,'String')) returns Step contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Step

function Mf_CreateFcn(varargin)

% --- Executes during object creation, after setting all properties.
function Step_CreateFcn(hObject, eventdata, handles)
global md grounded ice  logvalue
% hObject    handle to Step (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
strings=cell(length(md.results.TransientSolution),1);
for i=1:length(md.results.TransientSolution),
    strings{i}=sprintf('%4.2f     (%i)',md.results.TransientSolution(i).time,i);
end
if length(strings)>20,
    %too many strings, reduce!
    lt=length(strings);
    modlt=lt/20;
    strings=strings(1:modlt:end);
end
set(hObject,'String',strings);
% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Log.
function Log_Callback(hObject, eventdata, handles)
global grounded ice  logvalue
% hObject    handle to Log (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();
% Hint: get(hObject,'Value') returns toggle state of Log


% --- Executes on button press in Lock.
function Lock_Callback(hObject, eventdata, handles)
% hObject    handle to Lock (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();
% Hint: get(hObject,'Value') returns toggle state of Lock


% --- Executes on button press in Collock.
function Collock_Callback(hObject, eventdata, handles)
% hObject    handle to Collock (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();
% Hint: get(hObject,'Value') returns toggle state of Collock


% --- Executes on selection change in Field.
function Field_Callback(hObject, eventdata, handles)
% hObject    handle to Field (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

strings=get(hObject,'String'); value=get(hObject,'Value');
string=strings(value); 

if strcmpi(string,'IceVolume') | strcmpi(string,'IceVolumeAboveFloatation'),
	plotv();
else
	plotm();
end
% Hints: contents = cellstr(get(hObject,'String')) returns Field contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Field


% --- Executes during object creation, after setting all properties.
function Field_CreateFcn(hObject, eventdata, handles)
global md 
% hObject    handle to Field (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
fields=listfields(md,'TransientSolution');
set(hObject,'String',fields);
for i=1:length(fields), 
	if strcmpi(fields{i},'Vel'),
		set(hObject,'Value',i);
		break;
	end
end

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Cmin_Callback(hObject, eventdata, handles)
% hObject    handle to Cmin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();
% Hints: get(hObject,'String') returns contents of Cmin as text
%        str2double(get(hObject,'String')) returns contents of Cmin as a double


% --- Executes during object creation, after setting all properties.
function Cmin_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Cmin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
set(hObject,'String',num2str(NaN));
% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Cmax_Callback(hObject, eventdata, handles)
% hObject    handle to Cmax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Cmax as text
%        str2double(get(hObject,'String')) returns contents of Cmax as a double
plotm();


% --- Executes during object creation, after setting all properties.
function Cmax_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Cmax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
set(hObject,'String',num2str(NaN));
% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Time_Callback(hObject, eventdata, handles)
% hObject    handle to Time (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Time as text
%        str2double(get(hObject,'String')) returns contents of Time as a double


% --- Executes during object creation, after setting all properties.
function Time_CreateFcn(hObject, eventdata, handles)
global md
% hObject    handle to Time (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
set(hObject,'String',sprintf('%4.2f',md.results.TransientSolution(1).time));
% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over Time.
function Time_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to Time (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over Grounded.
function Grounded_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to Grounded (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in Grounded.
function Grounded_Callback(hObject, eventdata, handles)
% hObject    handle to Grounded (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();

% Hint: get(hObject,'Value') returns toggle state of Grounded

% --- Executes on key press with focus on Grounded and none of its controls.
function Grounded_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to Grounded (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)

% --- Executes on button press in Ice.
function Ice_Callback(hObject, eventdata, handles)
% hObject    handle to Ice (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();
% Hint: get(hObject,'Value') returns toggle state of Ice

% --- Executes on key press with focus on Ice and none of its controls.
function Ice_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to Ice (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in Ocean.
function Ocean_Callback(hObject, eventdata, handles)
% hObject    handle to Ocean (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();
% Hint: get(hObject,'Value') returns toggle state of Ocean


% --- Executes on key press with focus on Ocean and none of its controls.
function Ocean_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to Ocean (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Mask_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to Mask (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on selection change in DiffStep.
function DiffStep_Callback(hObject, eventdata, handles)
% hObject    handle to DiffStep (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();

% Hints: contents = cellstr(get(hObject,'String')) returns DiffStep contents as cell array
%        contents{get(hObject,'Value')} returns selected item from DiffStep


% --- Executes during object creation, after setting all properties.
function DiffStep_CreateFcn(hObject, eventdata, handles)
global md;
% hObject    handle to DiffStep (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
strings=cell(length(md.results.TransientSolution),1);
for i=1:length(md.results.TransientSolution),
    strings{i}=sprintf('%4.2f     (%i)',md.results.TransientSolution(i).time,i);
end
if length(strings)>20,
    %too many strings, reduce!
    lt=length(strings);
    modlt=lt/20;
    strings=strings(1:modlt:end);
end
set(hObject,'String',strings);

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over DiffStep.
function DiffStep_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to DiffStep (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in Diff.
function Diff_Callback(hObject, eventdata, handles)
% hObject    handle to Diff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();
% Hint: get(hObject,'Value') returns toggle state of Diff


% --- Executes during object creation, after setting all properties.
function Diff_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Diff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes on selection change in ModelFields.
function ModelFields_Callback(hObject, eventdata, handles)
% hObject    handle to ModelFields (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();
% Hints: contents = cellstr(get(hObject,'String')) returns ModelFields contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ModelFields


% --- Executes during object creation, after setting all properties.
function ModelFields_CreateFcn(hObject, eventdata, handles)
global md
% hObject    handle to ModelFields (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
fields={'md.geometry.thickness','md.inversion.vel_obs','md.geometry.surface'};
set(hObject,'String',fields);
% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Mf.
function Mf_Callback(hObject, eventdata, handles)
% hObject    handle to Mf (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plotm();
% Hint: get(hObject,'Value') returns toggle state of Mf
