
/*
	PengridLoad.h
*/


#ifndef _PENGRIDLOAD_H
#define _PENGRIDLOAD_H


#include "./PengridLoad.h"

#include "../InternalGrid.h"

/* element matrices: */
#include "../objects.h"

#include "../Pengrid.h"

typedef struct {

	Pengrid pengrid;
	
	/* "friend" class object pointers and indices: */
	int				internalgrid_index;
	int				internalgrid_indexb;
	InternalGrid*	pg;	

	int             matpar_index;
	int             matpar_enum;      
	void*           matpar; 

} PengridLoad;


/* creation, initialisation: */

	PengridLoad*	NewPengridLoad( void* vppengrid);	/* cast to Pengrid */

	/* "virtual" functions, used or required by DataSet: */

	void  DeletePengridLoad( void* *vpthis);	/* void*'s only for compatibility */
	void  PengridLoadEcho( void* vpthis );
	int   PengridLoadSizeOfInDoubles( void* vpthis);
	void  PengridLoadShrinkWrap( void* to, void* vpthis);
	int   PengridLoadUnwrap( void* vpthis);
	void  PengridLoadMarshall( char* *pbuffer, void* vpthis, int* size);
	void* PengridLoadDemarshall( DataSet* ds, char* *pbuffer, int machine_flag); 
	int   PengridLoadGetID( void* this);
	int   PengridLoadSetVirtualFunctions( void* vf);


/* other "virtual" functions: */

	/* general: */

	char*     PengridLoadGetName( void* vpthis);
	int     PengridLoadConfigure( void* vpthis, int num_datasets, ...);
	
	int PengridLoadAddToDataSet( DataSet* dataset, PengridLoad* this);
	
	/* load functionality: */
	int PengridLoadPenaltyCreateKMatrix( ElemMatrix* *pKe_gg, void* vpthis, ParameterInputs* inptus, int K_flag, double kmax,int analysis_type);
	int PengridLoadPenaltyCreateKMatrixThermal( ElemMatrix* *pKe_gg, void* vpthis, ParameterInputs* inputs, int K_flag, double kmax, int analysis_type);
	int PengridLoadPenaltyCreateKMatrixMelting( ElemMatrix* *pKe_gg, void* vpthis, ParameterInputs* inputs, int K_flag, double kmax, int analysis_type);

	int PengridLoadPenaltyCreatePVector( ElemVector* *ppe_g, void* vpthis, ParameterInputs* inputs, double kmax, int analysis_type);
	int PengridLoadPenaltyCreatePVectorThermal( ElemVector* *ppe_g, void* vpthis, ParameterInputs* inputs, double kmax, int analysis_type);
	int PengridLoadPenaltyCreatePVectorMelting( ElemVector* *ppe_g, void* vpthis, ParameterInputs* inputs, double kmax, int analysis_type);

	int PengridLoadPenaltyConstrain(int* punstable, void* vpthis,ParameterInputs* inputs, int analysis_type);

#endif  

