%Test Name: ValleyGlacierLevelsetEnthalpyHO3d
md=triangle(model(),'../Exp/Square.exp',50000);
md=setmask(md,'','');
md=parameterize(md,'../Par/ValleyGlacierShelf.par');
md=extrude(md,3,2.);
md=setflowequation(md,'HO','all');
md.cluster=generic('name',oshostname(),'np',3);

%Thermal model
pos_surf=find(md.mesh.vertexonsurface);
md.thermal.spctemperature(pos_surf)=md.initialization.temperature(pos_surf);
md.thermal.isenthalpy=1;
md.thermal.isdynamicbasalspc=1;

%Transient
md.transient.isstressbalance=1;
md.transient.ismovingfront=1;
md.transient.ismasstransport=1;
md.transient.issmb=1;
md.transient.isthermal=1;
md.transient.isgroundingline=1;
md.transient.isgia=0;

md=solve(md,'Transient');

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vel1','Pressure1','Thickness1','Surface1','MaskIceLevelset1','Enthalpy1','Watercolumn1',...
		'Vx2','Vy2','Vel2','Pressure2','Thickness2','Surface2','MaskIceLevelset2','Enthalpy2','Watercolumn2',...
		'Vx3','Vy3','Vel3','Pressure3','Thickness3','Surface3','MaskIceLevelset3','Enthalpy3','Watercolumn3'};
field_tolerances={1e-10,1e-10,1e-10,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
		1e-9,1e-9,1e-10,1e-10,1e-10,1e-10,1e-10,1e-9,1e-10,...
		1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10};
field_values={...
	md.results.TransientSolution(1).Vx,...
	md.results.TransientSolution(1).Vy,...
	md.results.TransientSolution(1).Vel,...
	md.results.TransientSolution(1).Pressure,...
	md.results.TransientSolution(1).Thickness,...
	md.results.TransientSolution(1).Surface,...
	md.results.TransientSolution(1).MaskIceLevelset,...
	md.results.TransientSolution(1).Enthalpy,...
	md.results.TransientSolution(1).Watercolumn,...
	md.results.TransientSolution(2).Vx,...
	md.results.TransientSolution(2).Vy,...
	md.results.TransientSolution(2).Vel,...
	md.results.TransientSolution(2).Pressure,...
	md.results.TransientSolution(2).Thickness,...
	md.results.TransientSolution(2).Surface,...
	md.results.TransientSolution(2).MaskIceLevelset,...
	md.results.TransientSolution(2).Enthalpy,...
	md.results.TransientSolution(2).Watercolumn,...
	md.results.TransientSolution(3).Vx,...
	md.results.TransientSolution(3).Vy,...
	md.results.TransientSolution(3).Vel,...
	md.results.TransientSolution(3).Pressure,...
	md.results.TransientSolution(3).Thickness,...
	md.results.TransientSolution(3).Surface,...
	md.results.TransientSolution(3).MaskIceLevelset,...
	md.results.TransientSolution(3).Enthalpy,...
	md.results.TransientSolution(3).Watercolumn,...
	};
