#!/bin/bash
set -eu

#Some cleanup
rm -rf src  install

#Mercurial cloning: 
hg clone -r 268 http://mercurial.mcs.anl.gov//ad/AdjoinableMPI src

#Configure adjoinablempi
cd src
autoreconf -fi

./configure \
	--prefix="$ISSM_DIR/externalpackages/adjoinablempi/install" \
	--libdir="$ISSM_DIR/externalpackages/adjoinablempi/install/lib" \
	--with-mpi-root="$ISSM_DIR/externalpackages/mpich/install" \
	--enable-requestOnTrace

#Compile adjoinablempi 
make clean
if [ $# -eq 0 ]; then
	make 
else
	make -j $1
fi
make install
