adjacency = function(md) {
    //ADJACENCY -  compute adjacency matrix, list of vertices and list of weights.
    //
    //  function to create the adjacency matrix from the connectivity table.
    //
    //  the required output is:
    //    md.adj_mat     (double [sparse nv x nv], vertex adjacency matrix)
    //    md.qmu.vertex_weight        (double [nv], vertex weights)

    var indi=[[md.mesh.elements.map(function(x) { return x[0]; })], [md.mesh.elements.map(function(x) { return x[1]; })], [md.mesh.elements.map(function(x) { return x[2]; })]];
    var indj=[md.mesh.elements.map(function(x) { return x[1];  }), [md.mesh.elements.map(function(x) { return x[2]; })], [md.mesh.elements.map(function(x) { return x[0]; })]];
    var values=1;

    md.qmu.adjacency=math.eye(md.mesh.numberofvertices, md.mesh.numberofvertices, 'sparse');

    for (var i = 0; i < indi.length; ++i) {
        for (var j = 0; j < indj.length; ++j) {
            //md.qmu.adjacency[indi[i]][indj[j]] = values;
            md.qmu.adjacency.subset(math.index(i, j), values);
        }
    }

    var tempadj = math.subset(md.qmu.adjacency, math.index(0,math.range(0, math.size(md.qmu.adjacency)._data[1])))

    //var tempadj = md.qmu.adjacency[0].map(function(col, i) { return md.qmu.adjacency.map(function(row) { return row[i]; }); });
    //md.qmu.adjacency=[md.qmu.adjacency[0].map(function(x, idx) { return md.qmu.adjacency.map(function(row, jdx) { return md.qmu.adjacency[idx][jdx] | tempadj[i][j]; })})];
    //md.qmu.adjacency=[tempadj.map(function(x, idx) { return md.qmu.adjacency.map(function(row, jdx) { return md.qmu.adjacency.subset(math.index(idx, jdx), md.qmu.adjacency.get([idx, jdx]) | tempadj.get([idx,jdx]));})})];

    for (var i = 0; i < math.size(md.qmu.adjacency)._data[0]; ++i) {
        for (var j = 0; j < math.size(md.qmu.adjacency)._data[1]; ++j) {
            md.qmu.adjacency.subset(math.index(i,j), md.qmu.adjacency.subset(math.index(i,j)) | md.qmu.adjacency.subset(math.index(j,i)));
        }
    }
    //[tempadj.forEach(function(x, idx) { md.qmu.adjacency.forEach(function(y, jdx) { console.log(idx, jdx); return md.qmu.adjacency.subset(math.index(idx, jdx), md.qmu.adjacency.subset(math.index(idx, jdx)) );})})];

    //now, build vwgt:
    areas=GetAreas(md.mesh.elements,md.mesh.x,md.mesh.y);

    //get node connectivity
    md.mesh.vertexconnectivity=NodeConnectivity(md.mesh.elements,md.mesh.numberofvertices);

    connectivity=md.mesh.vertexconnectivity.map(function(row) { return row.slice(0,row.length-1); });
    pos=[];
    for (var i = 0; i < connectivity.length; ++i) {
        if ((connectivity[i] !== 0)) {
                pos.push(i);
        }
    }

    console.log(areas);

    var tempconn = pos.map(function(val, idx) { return connectivity[val]; });

    pos.forEach(function(val, idx) {
        connectivity[val] = areas[connectivity[val]]/3;
    });

    md.qmu.vertex_weight=math.sum(connectivity);

    return md;
};
