#!/bin/bash
set -eu

#Some cleanup
rm -rf src  install

#Mercurial cloning: 
hg clone http://mercurial.mcs.anl.gov//ad/AdjoinableMPI src

#Configure adjoinablempi
cd src
autoreconf -fi

./configure \
	--prefix="$ISSM_DIR/externalpackages/adjoinablempi/install" \
	--libdir="$ISSM_DIR/externalpackages/adjoinablempi/install/lib" \
	--with-mpi-root="/nasa/sgi/mpt/2.06rp16/" \
	--enable-requestOnTrace

#Compile adjoinablempi 
make clean
if [ $# -eq 0 ]; then
	make 
else
	make -j $1
fi
make install
