function download() {
	//DOWNLOAD - save model/variable data to file
	//
	//   Usage:
	//      download=download('id','slr-download');
	//      download=download('id','slr-download','data',md.geometry.thickness,'data',md.results.Stressbalance.Vel);

	//Convert arguments to options
	var args = Array.prototype.slice.call(arguments);
	var options = new pairoptions(args.slice());
	
	//Recover option values:
	var id = options.getfieldvalue('id','');
	
	document.getElementById(id).addEventListener('click', function() {
		var data = {'elements':md.mesh.elements,'x':md.mesh.x,'y':md.mesh.y,'z':md.mesh.z};
		for (var i=2; i < args.length; i+=2) {
			try { 
				data[args[i]] = args[i+1];
			}
			catch (e) { 
				console.log(e); 
			}
		}
		string = JSONfn.stringify(data);
		
		var url='data:text/json:charset=utf8,' + encodeURIComponent(string);
		window.open(url, '_blank');
		window.focus();
	});
}
