import os.path
import numpy
import inspect
from verbose import verbose
from InterpFromMeshToMesh2d import InterpFromMeshToMesh2d
from paterson import paterson
from SetIceSheetBC import SetIceSheetBC
from arch import *

#Start defining model parameters here

#Geometry
hmin=300.
hmax=1000.
ymin=numpy.min(md.mesh.y)
ymax=numpy.max(md.mesh.y)
xmin=min(md.mesh.x)
xmax=max(md.mesh.x)
md.geometry.thickness=hmax+(hmin-hmax)*(md.mesh.y-ymin)/(ymax-ymin)+0.1*(hmin-hmax)*(md.mesh.x-xmin)/(xmax-xmin)
md.geometry.base=-md.materials.rho_ice/md.materials.rho_water*md.geometry.thickness+20.
md.geometry.surface=md.geometry.base+md.geometry.thickness

#Initial velocity 
x         = numpy.array(archread('../Data/SquareSheetConstrained.arch','x'))
y         = numpy.array(archread('../Data/SquareSheetConstrained.arch','y'))
vx        = numpy.array(archread('../Data/SquareSheetConstrained.arch','vx'));
vy        = numpy.array(archread('../Data/SquareSheetConstrained.arch','vy'));
index     = archread('../Data/SquareSheetConstrained.arch','index').astype(int);

[md.initialization.vx]=InterpFromMeshToMesh2d(index,x,y,vx,md.mesh.x,md.mesh.y)
[md.initialization.vy]=InterpFromMeshToMesh2d(index,x,y,vy,md.mesh.x,md.mesh.y)
md.initialization.vz=numpy.zeros((md.mesh.numberofvertices))
md.initialization.pressure=numpy.zeros((md.mesh.numberofvertices))

#Materials
md.initialization.temperature=(273.-20.)*numpy.ones((md.mesh.numberofvertices))
md.materials.rheology_B=paterson(md.initialization.temperature)
md.materials.rheology_n=3.*numpy.ones((md.mesh.numberofelements))

#Calving
md.calving.calvingrate=0.*numpy.ones((md.mesh.numberofvertices))
md.levelset.spclevelset=float('NaN')*numpy.ones((md.mesh.numberofvertices))

#Friction
md.friction.coefficient=20.*numpy.ones((md.mesh.numberofvertices))
md.friction.coefficient[numpy.nonzero(md.mask.groundedice_levelset<0.)[0]]=0.
md.friction.p=numpy.ones((md.mesh.numberofelements))
md.friction.q=numpy.ones((md.mesh.numberofelements))

#Numerical parameters
md.stressbalance.viscosity_overshoot=0.0
md.masstransport.stabilization=1.
md.thermal.stabilization=1.
md.verbose=verbose(0)
md.settings.waitonlock=30
md.stressbalance.restol=0.05
md.steadystate.reltol=0.05
md.stressbalance.reltol=0.05
md.stressbalance.abstol=float('NaN')
md.timestepping.time_step=1.
md.timestepping.final_time=3.

#GIA:
md.gia.lithosphere_thickness=100.*numpy.ones((md.mesh.numberofvertices)); # in km
md.gia.mantle_viscosity=1.*10**21*numpy.ones((md.mesh.numberofvertices)); # in Pa.s
md.materials.lithosphere_shear_modulus=6.7*10**10;                          # in Pa
md.materials.lithosphere_density=3.32;                                      # in g/cm^-3
md.materials.mantle_shear_modulus=1.45*10**11;                              # in Pa
md.materials.mantle_density=3.34;                                           # in g/cm^-3

#Boundary conditions:
md=SetIceSheetBC(md)

#Change name so that no test have the same name
if len(inspect.stack()) > 2:
	md.miscellaneous.name = os.path.basename(inspect.stack()[2][1]).split('.')[0]
