function diagnostics(md,varargin) 
%DIAGNOSTICS: output all sort of information as shape files.

	%process options: 
	options=pairoptions(varargin{:});
	path=getfieldvalue(options,'path','./');

	%mesh:
	if getfieldvalue(options,'mesh',0),
		mesh2shp(md,[path '/mesh']);
	end

	%grounding line : 
	if getfieldvalue(options,'gl',0),
		contours=contourlevelzero(md,md.mask.groundedice_levelset,0);
		expwrite(contours,[path '/groundingline.exp']);
		exp2shp([path '/groundingline.shp'],[path '/groundingline.exp']);
	end

	%velocity: 
	if exist(options,'vel'),
		vel=getfieldvalue(options,'vel',md.initialization.vel);
		xposting=getfieldvalue(options,'velposting',500);
		yposting=getfieldvalue(options,'velposting',500);

		xmin=min(md.mesh.x); ymax=max(md.mesh.y); 
		ncols=(max(md.mesh.x)-min(md.mesh.x))/xposting+1;
		nlines=(max(md.mesh.y)-min(md.mesh.y))/yposting+1;
		
		[xm,ym,vel]=InterpFromMeshToGrid(md.mesh.elements,md.mesh.x,md.mesh.y,vel,xmin,ymax,xposting,yposting,nlines,ncols,0);
		vel=uint16(flipud(vel));

		imwrite(vel,[path '/vel.tif'],'tiff');

		string=sprintf('!gdal_translate -a_srs EPSG:3031 -a_ullr %g %g %g %g %s/vel.tif %s/velg.tif',...
		min(md.mesh.x),max(md.mesh.y),max(md.mesh.x),min(md.mesh.y),path,path);
		eval(string);

	end

	%hot spots: 
	if getfieldvalue(options,'hotspots',0),
		threshold=getfieldvalue(options,'threshold',5000);
		i=getfieldvalue(options,'hotspotsi',length(md.results.TransientSolution));
		pos=find(md.results.TransientSolution(i).Vel>threshold);
		contour.x=md.mesh.x(pos); contour.y=md.mesh.y(pos); contour.density=1;
		expwrite(contour,[path '/hotspots.exp']);
		exp2shp([path '/hotspots.shp'],[path '/hotspots.exp']);
	end
