


try:
	import pylab as p
except ImportError:
	print "could not import pylab, matplotlib has not been installed, no plotting capabilities enabled"

import numpy as  np
from processmesh import processmesh
from applyoptions import applyoptions
from plot_icefront import plot_icefront

def plot_vertexnumbering(md,options,fig,ax):
    '''
	PLOT_VERTEXNUMBERING - plot vertex numbering

   	Usage:
      	plot_vertexnumbering(md,options,fig,axes);

 	See also: PLOTMODEL

	'''
	#process data and model
    x,y,z,elements,is2d,isplanet=processmesh(md,[],options)
    XLims=[np.min(x),np.max(x)]
    YLims=[np.min(y),np.max(y)]
    #plot mesh
    ax.triplot(x,y,elements)
    highlightpos=options.getfieldvalue('highlight','none')
    if highlightpos!='none':
        #if just one element duplicate it to avoid coloring issues
        if type(highlightpos)==int:
            highlightpos=[highlightpos,highlightpos]
        #convert from to matlab numbering
        highlightpos=[pos-1 for pos in highlightpos]
        colors=np.asarray([0.5 for element in elements[highlightpos]])
        ax.tripcolor(x,y,vertices[highlightpos],facecolors=colors,alpha=0.5)
    # and numbers
	
    for i,element in enumerate(elements):
        for j in [0,1,2]:
            ax.text(x[element][j],y[element][j],str(element[j]))	
	
    #apply options
    options.addfielddefault('title','Vertex numbers')
    options.addfielddefault('colorbar','off')
    applyoptions(md,[],options,fig,ax)
