function exp2shp(shapefilename,expfilename,geometry)
%SHPWRITE - write a shape file from a contour structure
%
%   Usage:
%      exp2shp(shapefilename,expfilename,geometry)
%
%   Example:
%      exp2shp('domainoutline.shp','domainoutline.exp')
%      exp2shp('domainoutline.shp','domainoutline.exp','Polygon')
%      exp2shp('massfluxgate.shp','massfluxgate.exp','Line')
%
%   See also SHPREAD, SHPWRITE, SHP2EXP

shp=expread(expfilename);

%initialize number of profile
count=0;

contours=struct([]);
for i=1:length(shp),
	if nargin < 3
		if length(shp(1).x) == 1
			geometry = 'Point';
		elseif length(shp(1).x) < 3
			geometry = 'Line';
		else 
			if (shp(1).x(end)==shp(1).x(1) && shp(1).y(end)==shp(1).y(1)),
				geometry = 'Polygon'
			else
				geometry = 'Line'
			end
		end
	end
	contours(i).Geometry=geometry;
	contours(i).id=i;
	contours(i).X=shp(i).x;
	contours(i).Y=shp(i).y;
end
	
shapewrite(contours,shapefilename);
end
