function varargout=updatearchive(varargin)
%RUNME - test deck for ISSM nightly runs
%
%   Usage:
%      varargout=updatearchive(varargin);
%
%   Examples:
%      updatearchive;
%      updatearchive({'ice'});
%      updatearchive({'ice','cielo_serial'},{'diagnostic'});
%      md=updatearchive({'cielo_parallel'});
%
%   See Also: UPDATEARCHIVE

% This file can be run to check that the current version of issm is giving 
% coherent results. This test deals with an icesheet without icefront for a 2d model. The geometry 
% is square. Just run this file in Matlab, with a properly setup ISSM code. 
% The results of this test will indicate if there is a difference between current computations 
% and archived results.

% Errors  between archived results and the current version will get flagged if they are not within 
% a certain tolerance. The current tolerance is 10^-12. If you have good reasons to believe this 
% tolerance should be lowered (for example, if you are running single precision compilers?), feel 
% free to tweak the tolerance variable.

%check arguments
if nargout>1
	help updatearchive
	error('updatearchive error message: bad usage');
end

%call updatearchive_core
md=updatearchive_core(varargin{:},'update');

%output model md if requested
if nargout==1, 
	varargout{1}=md; 
end
