try:
	import pylab as p
except ImportError:
	print "could not import pylab, matplotlib has not been installed, no plotting capabilities enabled"

import numpy as np
from processmesh import processmesh
from applyoptions import applyoptions
from plot_icefront import plot_icefront

def plot_BC(md,options,fig,ax):
	'''
	PLOT_BC - plot model boundary conditions

		Usage:
			plot_BC(md,options,fig,axes)

		See also: PLOTMODEL
	'''
	
	#plot neuman
	plot_icefront(md,options,fig,ax)
	x,y,z,elements,is2d,isplanet=processmesh(md,[],options)
	XLims=[np.min(x),np.max(x)]
	YLims=[np.min(y),np.max(y)]
	#plot dirichlets
	dirichleton=options.getfieldvalue('dirichlet','on')
	if dirichleton=='on':
		ax.scatter(x[np.where(~np.isnan(md.stressbalance.spcvx))],
							 y[np.where(~np.isnan(md.stressbalance.spcvx))],
							 marker='o',c='r',s=240,label='vx Dirichlet',linewidth=0)
		ax.scatter(x[np.where(~np.isnan(md.stressbalance.spcvy))],
							 y[np.where(~np.isnan(md.stressbalance.spcvy))],
							 marker='o',c='b',s=160,label='vy Dirichlet',linewidth=0)
		ax.scatter(x[np.where(~np.isnan(md.stressbalance.spcvz))],
							 y[np.where(~np.isnan(md.stressbalance.spcvz))],
							 marker='o',c='y',s=80,label='vz Dirichlet',linewidth=0)

		ax.set_xlim(XLims)
		ax.set_ylim(YLims)
	ax.legend()
	#apply options
	options.addfielddefault('title','Boundary conditions')
	options.addfielddefault('colorbar','off')
	applyoptions(md,[],options,fig,ax)
	
