from expread import expread
import numpy as np

def expdisp(ax,options):
    '''
    plot the contents of a domain outline file

    This routine reads in an exp file and plots all of the x,y points/lines/patches

    'ax' is a handle to the current plot axes, onto which we want to plot

    Usage:
        expdisp(domainoutline,ax)

    Example:
        expdisp('domain.exp',plt.gca(),linestyle='--k',linewidth=2,unitmultiplier=1.e3)
    '''

    filename=options.getfieldvalue('expdisp')
    style=options.getfieldvalue('expstyle','k')
    linewidth=options.getfieldvalue('explinewidth',1)
    unitmultiplier=options.getfieldvalue('unit',1)
    for i in xrange(len(filename)):
	filenamei=filename[i]
	stylei=style[i]
	if type(linewidth)==list:
	    linewidthi=linewidth[i]
	else:
	    linewidthi=linewidth

        domain=expread(filenamei)
        for i in xrange(len(domain)):
            if domain[i]['nods']==1:
                ax.plot(domain[i]['x']*unitmultiplier,domain[i]['y']*unitmultiplier,'o',mec='k',mfc='r',ms=10)
            else:
                x=domain[i]['x'].tolist() # since expread returns a string representation of the arrays
                y=domain[i]['y'].tolist()
                ax.plot(x*unitmultiplier,y*unitmultiplier,stylei,linewidth=linewidthi)
