/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*  $Id: mergelogs.c,v 1.5 2002/11/11 13:50:50 gropp Exp $
 *
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */

#include "dlog.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int g_bPrintOnly = 0;

void PrintRecord(DLOG_HEADER *pHeader)
{    
    printf("%g ", pHeader->timestamp);

    switch (pHeader->type)
    {
    case DLOG_EVENT_TYPE:
	printf("DLOG_EVENT\n");
	break;
    case DLOG_OPEN_EVENT_TYPE:
	printf("DLOG_OPEN_EVENT\n");
	break;
    case DLOG_COMM_TYPE:
	printf("DLOG_COMM\n");
	break;
    case DLOG_STATE_TYPE:
	printf("DLOG_STATE\n");
	break;
    case DLOG_ENDLOG_TYPE:
	printf("DLOG_ENDLOG\n");
	break;
    default:
	printf("unknown record type %d\n", pHeader->type);
    }
}

static void StripArgs(int *argc, char ***argv, int n)
{
    int i;
    if (n+1 > *argc)
    {
	printf("Error: cannot strip %d args, only %d left.\n", n, *argc-1);
    }
    for (i=n+1; i<=*argc; i++)
    {
	(*argv)[i-n] = (*argv)[i];
    }
    (*argc) -= n;
}

int main(int argc, char *argv[])
{
    int i, index;
    int nNumInputs = 0;
    DLOG_IOStruct **pInputs = NULL;
    DLOG_IOStruct *pOutput = NULL;
    DLOG_HEADER header;

    if (argc > 1)
    {
	if (strcmp(&argv[1][1], "print") == 0)
	{
	    g_bPrintOnly = 1;
	    StripArgs(&argc, &argv, 1);
	}
    }

    if (argc < 3)
    {
	printf("%s outfile file1 file2 file3 ...\n", argv[0]);
	return -1;
    }

    if (!g_bPrintOnly)
    {
	/* create an output structure */
	pOutput = DLOG_CreateOutputStruct(argv[1]);
	if (pOutput == NULL)
	{
	    printf("unable to set up the output structure\n");
	    return -1;
	}
    }

    /* allocate an array of input structure pointers */
    nNumInputs = argc - 2;
    pInputs = (DLOG_IOStruct**)malloc(nNumInputs * sizeof(DLOG_IOStruct*));

    /* create the input structures for each clog input file */
    for (i=0; i<nNumInputs; i++)
    {
	pInputs[i] = DLOG_CreateInputStruct(argv[i+2]);
	if (pInputs[i] == NULL)
	{
	    printf("Error setting up file '%s'\n", argv[i+2]);
	    return -1;
	}
    }

    /* read records from all the input sources and write them out maintaining timestamp sorted order */
    while (nNumInputs)
    {
	/* find the earliest timestamp */
	index = 0;
	for (i=1; i<nNumInputs; i++)
	{
	    if (pInputs[i]->header.timestamp < pInputs[index]->header.timestamp)
		index = i;
	}
	if (g_bPrintOnly)
	{
	    PrintRecord((DLOG_HEADER*)pInputs[index]->pCurHeader);
	}
	else
	{
	    /* output the earliest record */
	    if (DLOG_WriteRecord((DLOG_HEADER*)pInputs[index]->pCurHeader, pOutput))
	    {
		printf("writing out the data failed.\n");
		return -1;
	    }
	}
	/* replace the written record with another from the same input source */
	if (DLOG_GetNextRecord(pInputs[index]))
	{
	    /* the input source is empty, so remove it */
	    nNumInputs--;
	    fclose(pInputs[index]->f);
	    free(pInputs[index]);
	    for (i=index; i<nNumInputs; i++)
		pInputs[i] = pInputs[i+1];
	}
    }

    /* add an ENDLOG record and write out the last block of data */
    header.timestamp = 0;
    header.type = DLOG_ENDLOG_TYPE;
    header.length = sizeof(DLOG_HEADER);
    /*
    CLOGByteSwapDouble (&(header.timestamp), 1);
    CLOGByteSwapInt (&(header.rectype), 3);
    memcpy(pOutput->pCurHeader, &header, sizeof(CLOG_HEADER));
    */
    if (g_bPrintOnly)
    {
	PrintRecord(&header);
    }
    else
    {
	DLOG_WriteRecord(&header, pOutput);
    }

    /* free allocated resources */
    free(pInputs);
    if (!g_bPrintOnly)
	DLOG_CloseOutputStruct(&pOutput);

    return 0;
}
