#!/usr/bin/env python

# Note that I repeat code for each test just in case I want to
# run one separately.  I can simply copy it out of here and run it. 
# A single test can typically be chgd simply by altering its value(s)
# for one or more of:
#     PYEXT, NMPDS, HFILE

import os, sys, commands
sys.path += [os.getcwd()]  # do this once

print "mpd tests---------------------------------------------------"

clusterHosts = [ 'bp4%02d' % (i)  for i in range(0,8) ]
print "clusterHosts=", clusterHosts

# test: simple with 1 mpd (mpdboot uses mpd's -e and -d options)
print "TEST -e -d"
PYEXT = '.py'
NMPDS = 1
HFILE = 'temph'
import os,socket
from mpdlib import MPDTest
mpdtest = MPDTest()
os.environ['MPD_CON_EXT'] = 'testing'
os.system("mpdallexit%s 1> /dev/null 2> /dev/null" % (PYEXT) )
os.system("mpdboot%s -1 -f %s -n %d" % (PYEXT,HFILE,NMPDS) )
expout = 'hello\nhello\nhello\n'
mpdtest.run(cmd="mpiexec%s -n 3 /bin/echo hello" % (PYEXT), chkOut=1, expOut=expout )
os.system("mpdallexit%s 1> /dev/null 2> /dev/null" % (PYEXT) )

# test: simple with 2 mpds on same machine (mpdboot uses mpd's -n option)
print "TEST -n"
PYEXT = '.py'
NMPDS = 2
HFILE = 'temph'
import os,socket
from mpdlib import MPDTest
mpdtest = MPDTest()
temph = open(HFILE,'w')
for i in range(NMPDS): print >>temph, '%s' % (socket.gethostname())
temph.close()
os.environ['MPD_CON_EXT'] = 'testing'
os.system("mpdallexit%s 1> /dev/null 2> /dev/null" % (PYEXT) )
os.system("mpdboot%s -1 -f %s -n %d" % (PYEXT,HFILE,NMPDS) )
expout = 'hello\nhello\n'
mpdtest.run(cmd="mpiexec%s -n 2 /bin/echo hello" % (PYEXT), chkOut=1, expOut=expout )
os.system("mpdallexit%s 1> /dev/null 2> /dev/null" % (PYEXT) )

# test: simple with 3 mpds on 3 machines  (-h and -p options)
print "TEST -h and -p"
PYEXT = '.py'
NMPDS = 3
HFILE = 'temph'
import os,socket
from mpdlib import MPDTest
mpdtest = MPDTest()
temph = open(HFILE,'w')
for host in clusterHosts: print >>temph, host
temph.close()
os.environ['MPD_CON_EXT'] = 'testing'
os.system("mpdallexit%s 1> /dev/null 2> /dev/null" % (PYEXT) )
os.system("mpdboot%s -1 -f %s -n %d" % (PYEXT,HFILE,NMPDS) )
expout = 'hello\nhello\nhello\n'
mpdtest.run(cmd="mpiexec%s -n 3 /bin/echo hello" % (PYEXT), chkOut=1, expOut=expout )
os.system("mpdallexit%s 1> /dev/null 2> /dev/null" % (PYEXT) )

# test: simple 2 mpds on local machine (-l option)
print "TEST -l"
PYEXT = '.py'
NMPDS = 3
HFILE = 'temph'
import os,socket
from mpdlib import MPDTest
mpdtest = MPDTest()
temph = open(HFILE,'w')
for host in clusterHosts: print >>temph, host
temph.close()
os.environ['MPD_CON_EXT'] = 'testing'
os.system("mpdallexit%s 1> /dev/null 2> /dev/null" % (PYEXT) )
os.system("mpd%s -d -l 12345" % (PYEXT) )
os.system("mpd%s -d -n -h %s -p 12345" % (PYEXT,socket.gethostname()) )
expout = 'hello\nhello\nhello\n'
mpdtest.run(cmd="mpiexec%s -n 3 /bin/echo hello" % (PYEXT), chkOut=1, expOut=expout )
os.system("mpdallexit%s 1> /dev/null 2> /dev/null" % (PYEXT) )

# test: simple with 2 mpds on 2 machines  (--ncpus option)
print "TEST --ncpus"
PYEXT = '.py'
NMPDS = 2
HFILE = 'temph'
import os,socket
from mpdlib import MPDTest
mpdtest = MPDTest()
temph = open(HFILE,'w')
for i in clusterHosts: print >>temph, host
temph.close()
os.environ['MPD_CON_EXT'] = 'testing'
os.system("mpdallexit%s 1> /dev/null 2> /dev/null" % (PYEXT) )
os.system("mpdboot%s -f %s -n %d --ncpus=2" % (PYEXT,HFILE,NMPDS) )
expout = '0: m1\n1: m1\n2: m2\n3: m2\n'
mpdtest.run(cmd="mpiexec%s -l -n 2 /bin/echo m1 : -n 2 /bin/echo m2" % (PYEXT), chkOut=1, expOut=expout )
os.system("mpdallexit%s 1> /dev/null 2> /dev/null" % (PYEXT) )

# test: simple with 2 mpds on 2 machines  (--ifhn option)
#   this is not a great test, but shows working with real ifhn, then failure with 127.0.0.1
print "TEST --ifhn"
PYEXT = '.py'
NMPDS = 2
HFILE = 'temph'
import os,socket
from mpdlib import MPDTest
mpdtest = MPDTest()
temph = open(HFILE,'w')
for host in clusterHosts:
    hostinfo = socket.gethostbyname_ex(host)
    IP = hostinfo[2][0]
    print >>temph, '%s ifhn=%s' % (host,IP)
temph.close()
os.environ['MPD_CON_EXT'] = 'testing'
os.system("mpdallexit%s 1> /dev/null 2> /dev/null" % (PYEXT) )
hostinfo = socket.gethostbyname_ex(socket.gethostname())
IP = hostinfo[2][0]
os.system("mpdboot%s -f %s -n %d --ifhn=%s" % (PYEXT,HFILE,NMPDS,IP) )
expout = 'hello\nhello\n'
mpdtest.run(cmd="mpiexec%s -n 2 /bin/echo hello" % (PYEXT), chkOut=1, expOut=expout )
os.system("mpdallexit%s 1> /dev/null 2> /dev/null" % (PYEXT) )
## redo the above test with a local ifhn that should cause failure
lines = commands.getoutput("mpdboot%s -f %s -n %d --ifhn=127.0.0.1" % (PYEXT,HFILE,NMPDS) )
if len(lines) > 0:
    if lines.find('error trying to start mpd(boot)') < 0:
        print "probable error in ifhn test using 127.0.0.1; printing lines of output next:"
        print lines
        sys.exit(-1)
