#Test Name: SquareSheetShelfTherTran
import numpy
from model import *
from MatlabFuncs import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/Square.exp',150000.)
md=setmask(md,'../Exp/SquareShelf.exp','')
md=parameterize(md,'../Par/SquareSheetShelf.py')
md.extrude(4,1.)
md=setflowequation(md,'HO','all')
md.cluster=generic('name',oshostname(),'np',3)
md.transient.isstressbalance=False
md.transient.ismasstransport=False
md.transient.issmb=True
md.transient.isthermal=True
md.transient.isgroundingline=False
md=solve(md,'Transient')

#Fields and tolerances to track changes
field_names     =['Temperature','BasalforcingsGroundediceMeltingRate']
field_tolerances=[1e-13,1e-13]
field_values=[\
	md.results.TransientSolution[0].Temperature,\
	md.results.TransientSolution[0].BasalforcingsGroundediceMeltingRate,\
	]
