import numpy
import cuffey

def cuffeytemperate(temperature, waterfraction, stressexp)

	"""
	CUFFEYTEMPERATE - calculates ice rigidity as a function of temperature and waterfraction

   rigidity (in s^(1/3)Pa) is the flow law parameter in the flow law sigma=B*e(1/3)
   (Cuffey and Paterson, p75). 
   temperature is in Kelvin degrees

   Usage:
      rigidity=cuffeytemperate(temperature, waterfraction, stressexp)
	"""

	if numpy.any(temperature<0.):
		raise RuntimeError("input temperature should be in Kelvin (positive)")

	if (numpy.any(temperature.shape~=waterfraction.shape)),
		error('input temperature and waterfraction should have same size!');
	end
	if numpy.any(waterfraction<0 | waterfraction>1)
		error('input waterfraction should be between 0 and 1');
	end

	rigidity=numpy.multiply(cuffey(temperature), (1*numpy.ones(waterfraction.shape)+181.25*numpy.maximum(numpy.zeros(waterfraction.shape), numpy.minimum(0.01*numpy.ones(waterfraction.shape), waterfraction)))**(-1/stressexp));

	return rigidity
