function Shp2Exp(expfilename,shapefilename)
%SHP2EXP- transform shape file to Argus .exp file
%
%   Usage:
%      Shp2Exp(expfilename,shapefilename);
%
%   Example:
%      Shp2Exp('Domain.exp','Domain.shp');
%
%   See also EXPMASTER, EXPDOC

	if ~exist(shapefilename,'file'),
		error(['Shapefile ' shapefilename ' does not exist']);
	end
	shp=shaperead(shapefilename);

	expstruct=struct([]);
	for i=1:length(shp),
		if strcmpi(shp(i).Geometry,'Polygon'),
			x=shp(i).X; y=shp(i).Y;
			ids=find(isnan(x));
			x(ids)=[]; y(ids)=[];
			expstruct(end+1).x=x;
			expstruct(end).y=y;
			expstruct(end).nods=length(x);
			expstruct(end).density=1;
			expstruct(end).closed=1;
			expstruct(end).name=num2str(shp(i).id);
		elseif strcmpi(shp(i).Geometry,'Point'),
			x=shp(i).X; y=shp(i).Y;
			expstruct(end+1).x=x;
			expstruct(end).y=y;
			expstruct(end).nods=length(x);
			expstruct(end).density=1;
			expstruct(end).closed=1;
			%exp(end).name=num2str(shp(i).id);
		elseif strcmpi(shp(i).Geometry,'Line'),
			x=shp(i).X; y=shp(i).Y;
			x(end)=x(1); y(end)=y(1);
			expstruct(end+1).x=x;
			expstruct(end).y=y;
			expstruct(end).nods=length(x);
			expstruct(end).density=1;
			expstruct(end).closed=1;
		end
	end

	expwrite(expstruct,expfilename);
