/* \file BuddJacka.cpp
 * \brief figure out B of ice for a certain temperature
 *	  INPUT function B=BuddJacka(temperature)
 *    where rigidity (in s^(1/3)Pa) is the flow law paramter in the flow law sigma=B*e(1/3) (Budd and Jacka, 1989). 
 */
#include <math.h>

#include "../Numerics/types.h"

IssmDouble BuddJacka(IssmDouble temperature){

	/*output: */
	IssmDouble B,T;

	/*Switch to celsius from Kelvin: */
	T=temperature-273.15;
	if(T<=-40.){
		B=1e8*(-0.000237326134296*pow(T+50.,3)+ 0.017054655749852*pow(T+50.,2)-0.496435984007500*(T+50.)+7.670967258739796);
	}
	else if(-40.<T & T<=-35.){
	 B=1e8*(-0.000237326134296*pow(T+40.,3)+ 0.009934871720961*pow(T+40.,2)-0.226540709299368*(T+40.)+4.174746859353635);
	}
	else if(-35.<T & T<=-30.){
		B=1e8*(-0.000293001369376*pow(T+35.,3)+ 0.006374979706516*pow(T+35.,2)-0.144991452161983*(T+35.)+3.260749339093782);
	}
	else if(-30.<T & T<=-25.){
		B=1e8*(-0.000053702836500*pow(T+30.,3)+ 0.001979959165871*pow(T+30.,2)-0.103216757800049*(T+30.)+2.658541399774723);
	}
	else if(-25.<T & T<=-20.){
		B=1e8*( 0.000006906867543*pow(T+25.,3)+ 0.001174416618375*pow(T+25.,2)-0.087444878878821*(T+25.)+2.185243735358781);
	}
	else if(-20.<T & T<=-15.){
		B=1e8*(-0.000015460250554*pow(T+20.,3)+ 0.001278019631513*pow(T+20.,2)-0.075182697629382*(T+20.)+1.778243114866868);
	}
	else if(-15.<T & T<=-10.){
		B=1e8*(-0.000110386100241*pow(T+15.,3)+ 0.001046115873209*pow(T+15.,2)-0.063562020105772*(T+15.)+1.432347586188582);
	}
	else if(-10.<T & T<=-5.){
		B=1e8*(-0.000108595885218*pow(T+10.,3)+-0.000609675630408*pow(T+10.,2)-0.061379818891767*(T+10.)+1.126892119959808);
	}
	else if(-5.<T & T<=-2.){
		B=1e8*( 0.000173187986430*pow(T+5.,3)+-0.002238613908676*pow(T+5.,2)-0.075621266587187*(T+5. )+0.791176649088537);
	}
	else if(-2.<T & T<=-1.){
		B=1e8*( 0.000429499435151*pow(T+2.,3)+-0.000679922030808*pow(T+2.,2)-0.084376874405640*(T+2. )+0.548841399782495);
	}
	else if(-1.<T){
		B=1e8*( 0.000429499435151*pow(T+1.,3)+ 0.000608576274646*pow(T+1.,2)-0.084448220161802*(T+1. )+0.464214102781199);
	}

	/*B cannot be negative!*/
	if(B<0) B=1.e+6;

	return B;
}
