#!/bin/sh
set -eu

export DEVROOT=`xcode-select --print-path`
export SDKROOT="$DEVROOT/Platforms/iPhoneOS.platform/Developer/SDKs/iPhoneOS7.1.sdk"
export CLANG="$DEVROOT/Toolchains/XcodeDefault.xctoolchain/usr/bin/clang"
export CLANGXX="$DEVROOT/Toolchains/XcodeDefault.xctoolchain/usr/bin/clang++"
export CC=$CLANG
export LD=$DEVROOT/usr/bin/ld
export CPPFLAGS="-isysroot $SDKROOT/usr/include"
export CXX=$CLANGXX
export CXXFLAGS="-O -arch armv7s -isysroot $SDKROOT -I$SDKROOT/usr/include" 
export CFLAGS="-O -arch armv7s -isysroot $SDKROOT -I$SDKROOT/usr/include"
export AR=$DEVROOT/Toolchains/XcodeDefault.xctoolchain/usr/bin/ar
export AS=$DEVROOT/Toolchains/XcodeDefault.xctoolchain/usr/bin/as
export LDFLAGS="-lstdc++ -arch armv7s -isysroot $SDKROOT" 
export LIBTOOL=$DEVROOT/Toolchains/XcodeDefault.xctoolchain/usr/bin/libtool
export STRIP=$DEVROOT/Toolchains/XcodeDefault.xctoolchain/usr/bin/strip
export RANLIB=$DEVROOT/Toolchains/XcodeDefault.xctoolchain/usr/bin/ranlib

./configure                                                        \
	--prefix=$ISSM_DIR                                              \
   --build="i386-apple-darwin13.1.0"                               \
   --host="armv7s-apple-darwin14.0.0"                               \
   --enable-shared                                                 \
   --with-ios=yes                                                  \
   --with-Gia=no                                                   \
   --without-fortran                                               \
	--without-wrappers                                              \
	--without-kriging                                               \
	--with-gsl-dir=$ISSM_DIR/externalpackages/gsl/install           \
	--with-triangle-dir=$ISSM_DIR/externalpackages/triangle/install \
