%
%  display for the dakota_method class.
%
%  []=display(dm)
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
function []=display(dm)

if ~isa(dm,'dakota_method')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(dm),'dakota_method');
end

%  display the object

for i=1:numel(dm)
    disp(sprintf('\nclass ''%s'' object ''%s%s'' = \n',...
        class(dm),inputname(1),string_dim(dm,i)));
    disp(sprintf('       method: ''%s'''  ,dm(i).method));
    disp(sprintf('         type: ''%s'''  ,dm(i).type));
    disp(sprintf('    variables: %s'      ,string_cell(dm(i).variables)));
    disp(sprintf('       lcspec: %s'      ,string_cell(dm(i).lcspec)));
    disp(sprintf('    responses: %s'      ,string_cell(dm(i).responses)));
    disp(sprintf('       ghspec: %s\n'    ,string_cell(dm(i).ghspec)));
    
%  display the parameters within the object

    fnames=fieldnames(dm(i).params);
    maxlen=0;
    for j=1:numel(fnames)
        maxlen=max(maxlen,length(fnames{j}));
    end
    
    for j=1:numel(fnames)
        disp(sprintf(['       params.%-' num2str(maxlen+1) 's: %s'],...
            fnames{j},any2str(dm(i).params.(fnames{j}))));
    end
end

end
