function tolerance=testsgettolerance(md,package,solution,field),
%TESTSGETTOLERANCE - give the tolerance for the nightly run 
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   It gives the accepted tolerance, given the package, the solution and the field check.
%
%   Usage:
%      tolerance=testsgettolerance(md,package,solution,field),
%
%   Example:
%      tolerance=testsgettolerance(md,'cielo','diagnostic','vel'),
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE

if (strcmpi(package,'macayeal') | strcmpi(package,'ice') | strcmpi(package,'cielo_serial')),
	tolerance=10^-12;

elseif strcmpi(package,'cielo_parallel'),
	if strcmpi(solution,'prognostic'),
		tolerance=10^-14;

	elseif strcmpi(solution,'transient'),
		if strcmpi(md.type,'2d'),
			tolerance=10^-11;
		else
			if md.isstokes,
				tolerance=10^-4;
			elseif any(md.gridonpattyn),
				tolerance=10^-6;
			else,
				tolerance=10^-12;
			end
		end

	elseif strcmpi(solution,'diagnostic'),
		if md.isstokes,
			tolerance=10^-4;
		elseif any(md.gridonpattyn),
			tolerance=10^-6;
		elseif ~isnans(md.rifts),
			tolerance=10^-10;
		else,
			tolerance=10^-13;
		end

	elseif (strcmpi(solution,'thermal_steady') | strcmpi(solution,'thermal_transient')),
		if strncmpi(fliplr(field),fliplr('melting'),7),
			tolerance=10^-6;
		elseif strncmpi(fliplr(field),fliplr('temperature'),11),
			tolerance=10^-11;
		end

	elseif (strcmpi(solution,'steadystate')),
			if md.isstokes,
				tolerance=5*10^-5;
			elseif any(md.gridonpattyn),
				tolerance=2*10^-8;
			else,
				tolerance=10^-10;
			end

	elseif (strncmpi(solution,'diagnostic_',11) | strncmpi(solution,'steadystate_',12) ),
		if strcmpi(md.type,'2d'),
			tolerance=10^-13;
		else
			tolerance=10^-10;
		end

	else
		error(['testsgettolerance error message: solution '  solution ' not supported yet with package cielo_parallel']);
	end

else
	error(['testsgettolerance error message: package '  package ' not supported yet']);
end
