/*\file MassFlux.c
 *\brief: compute mass flux along a profile.
 */

#include "./MassFlux.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	double*  segments=NULL;
	int      num_segments;
	double*  vx=NULL;
	double*  vy=NULL;
	double*  vz=NULL;
	mxArray* pfield=NULL;

	/* output datasets: */
	double   mass_flux;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&MassFluxUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);

	/*parameters: */
	FetchData((void**)&segments,&num_segments,NULL,mxGetField(PARAMETERS,0,"qmu_mass_flux_segments"),"Matrix","Mat");

	/*results: */
	FetchData((void**)&vx,NULL,NULL,mxGetField(RESULTS,0,"vx"),"Matrix","Mat");
	FetchData((void**)&vy,NULL,NULL,mxGetField(RESULTS,0,"vy"),"Matrix","Mat");
	pfield=mxGetField(RESULTS,0,"vz");
	if(pfield)FetchData((void**)&vz,NULL,NULL,pfield,"Matrix","Mat");

	/*!Compute mass flux along the profile: */
	MassFluxx(&mass_flux, elements,nodes,loads,materials,segments,num_segments,vx,vy,vz);

	/*write output datasets: */
	WriteData(RESPONSE,&mass_flux,0,0,"Scalar",NULL);
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);

	/*end module: */
	MODULEEND();
}

void MassFluxUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [Kgg,pg] = %s(eleemnts,nodes,loads,materials,params,inputs,analysis_type);\n",__FUNCT__);
	_printf_("\n");
}
