function qmumarshall(md,variables,responses)
%QMUMARSHALL - output ISSM compatible binary file with qmu fields. This is 
%   in addition to the marshall routine for regular solve routines.
%   Usage:
%      qmumarshall(md,variables,responses)
% 
%   where variables and responses are the Dakota variables and responses found in the model @md.

%some checks on list of arguments
if ((nargin~=3) & (nargout~=0))
	qmumarshallusage;
	error('marshall error message');
end

disp(['qmu marshalling file ' md.name '.bin']);

%open file for binary adding 
fid=fopen([ md.name '.bin'],'ab');
if fid==-1,
	error(['qmumarshall error message: could not open ' [md.name '.bin'],' file for binary adding']);
end

%count how many variables we have
numvariables=0;
variable_fieldnames=fieldnames(variables);
for i=1:length(variable_fieldnames),
	field_name=variable_fieldnames{i};
	fieldvariables=variables.(field_name);
	numvariables=numvariables+numel(variables.(field_name));
end
%write number of variables to disk
WriteData(fid,numvariables,'Integer','numberofvariables');

%now, for each variable, write descriptor
count=0;
for i=1:length(variable_fieldnames),
	field_name=variable_fieldnames{i};
	fieldvariables=variables.(field_name);
	for j=1:length(fieldvariables),
		descriptor=fieldvariables(j).descriptor;
		WriteData(fid,descriptor,'String',['variabledescriptor' num2str(count)]);
		count=count+1;
	end
end

%deal with responses

%count how many responses we have
numresponses=0;
response_fieldnames=fieldnames(responses);
for i=1:length(response_fieldnames),
	field_name=response_fieldnames{i};
	fieldresponses=responses.(field_name);
	numresponses=numresponses+numel(responses.(field_name));
end
%write number of responses to disk
WriteData(fid,numresponses,'Integer','numberofresponses');

%now, for each response, write descriptor
count=0;
for i=1:length(response_fieldnames),
	field_name=response_fieldnames{i};
	fieldresponses=responses.(field_name);
	for j=1:length(fieldresponses),
		descriptor=fieldresponses(j).descriptor;
		WriteData(fid,descriptor,'String',['responsedescriptor' num2str(count)]);
		count=count+1;
	end
end

%write response specific data
count=0;
for i=1:length(response_fieldnames),
	field_name=response_fieldnames{i};
	fieldresponses=responses.(field_name);
	for j=1:length(fieldresponses),
		descriptor=fieldresponses(j).descriptor;
		if strcmpi(descriptor,'mass_flux'),
			WriteData(fid,md.qmu_mass_flux_segments,'Mat','qmu_mass_flux_segments');
		end
	end
end

%write part and npart to disk
WriteData(fid,md.npart,'Integer','npart');
WriteData(fid,md.part,'Mat','part');

%close file
st=fclose(fid);
if st==-1,
	error(['qmumarshall error message: could not close file ' [md.name '.bin']]);
end

end

function qmumarshallusage();
disp(' ');
disp('function qmumarshall(md,variables,responses)');
end
