/*!\file MassFluxx
 * \brief: compute mass flux along a profile.
 */

#include "./MassFluxx.h"

#undef __FUNCT__ 
#define __FUNCT__ "MassFluxx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void MassFluxx(double* pmass_flux, DataSet* elements,DataSet* nodes,DataSet* loads,DataSet* materials,
		double* segments,int num_segments,double* vx,double* vy,double* vz){

	int i,j;
	extern int num_procs;
	extern int my_rank;
	
	Element* element=NULL;
	int element_id;
	
	/*output: */
	double mass_flux=0;
	double all_mass_flux=0;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes, materials);
	loads->Configure(elements, loads, nodes, materials);

	/*Go through segments, and then elements, and figure out which elements belong to a segment. 
	 * When we find one, use the element to compute the mass flux on the segment: */

	for(i=0;i<num_segments;i++){
		element_id=(int)*(segments+5*i+4);
		for(j=0;j<elements->Size();j++){
			element=(Element*)elements->GetObjectByOffset(j);
			if (element->GetId()==element_id){
				/*We found the element which owns this segment, use it to compute the mass flux: */
				mass_flux+=element->MassFlux(segments+5*i+0,vx,vy,vz);
			}
		}
	}

	#ifdef _PARALLEL_
		MPI_Allreduce ( (void*)&mass_flux,(void*)&all_mass_flux,1,MPI_DOUBLE,MPI_SUM,MPI_COMM_WORLD);
		all_mass_flux=mass_flux;
	#endif

	/*Assign output pointers: */
	*pmass_flux=mass_flux;
}
