/*!\file: depthaverage_core.cpp
 * \brief: core of the extrusion solution
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../solutionsequences/solutionsequences.h"
#include "../modules/modules.h"

void depthaverage_core(FemModel* femmodel){

	if(VerboseSolution()) _printf0_("depth averaging solution...\n");

	/*Get parameters*/
	femmodel->parameters->FindParam(&domaintype,DomainTypeEnum);
	femmodel->parameters->FindParam(&elementtype,MeshElementtypeEnum);

	/*If this is a 2D horizontal domain, return (no need to extrude)*/
	if(domaintype==Domain2DhorizontalEnum) return;

	/*Special method for Penta, otherwise call solution sequence*/
	if(elementtype==PentaEnum){
		int inputenum,input_average_enum;
		femmodel->parameters->FindParam(&inputenum,InputToDepthaverageInEnum);
		femmodel->parameters->FindParam(&input_average_enum,InputToDepthaverageOutEnum);
		InputDepthAverageAtBasex(femmodel,inputenum,input_average_enum);
	}
	else{
		/*Call on core computations: */
		femmodel->SetCurrentConfiguration(DepthAverageAnalysisEnum);
		solutionsequence_linear(femmodel);
	}
}
