#Test Name: SquareSheetConstrainedStressSSA3d
from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',180000.)
md=setmask(md,'','')
md=parameterize(md,'../Par/SquareSheetConstrained.py')
md.extrude(3,2.)
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,'Stressbalance')

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vz','Vel','Pressure']
field_tolerances=[1e-13,1e-13,1e-13,1e-13,1e-13]
field_values=[\
	md.results.StressbalanceSolution.Vx,\
	md.results.StressbalanceSolution.Vy,\
	md.results.StressbalanceSolution.Vz,\
	md.results.StressbalanceSolution.Vel,\
	md.results.StressbalanceSolution.Pressure,\
	]
