#Test Name: SquareShelfStressSSA2dDamageRift
import numpy
from model import model
from triangle import triangle
from setmask import setmask
from parameterize import parameterize
from setflowequation import setflowequation
from solve import solve
from socket import gethostname as oshostname
from matdamageice import matdamageice
from meshprocessrifts import meshprocessrifts
from generic import generic

md=triangle(model(),'../Exp/SquareHole.exp','../Exp/Rifts.exp',50000.)
md=meshprocessrifts(md,'../Exp/Square.exp')
md=setmask(md,'all','')
md.materials=matdamageice()
md=parameterize(md,'../Par/SquareShelf2.py')
md.damage.isdamage=1
md.damage.D=0.5*numpy.ones(md.mesh.numberofvertices)
md.damage.spcdamage=numpy.nan*numpy.ones(md.mesh.numberofvertices)
md=setflowequation(md,'SSA','all')

md.cluster=generic('name',oshostname(),'np',3)
print md.rifts.riftstruct[0]['fill']
md=solve(md,'StressbalanceSolution')

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vel','Pressure']
field_tolerances=[7e-8,3e-8,3e-8,1e-11]
field_values=[\
	   md.results.StressbalanceSolution.Vx,\
	   md.results.StressbalanceSolution.Vy,\
	   md.results.StressbalanceSolution.Vel,\
	   md.results.StressbalanceSolution.Pressure,\
	   ]
