function outoptions=process_solve_options(options)
%DEFAULT_SOLVE_OPTIONS - set up default options for solve phase
%
%   Usage:
%      options=process_solve_options(options)
%
%   See also: SOLVE,RECOVER_SOLVE_OPTIONS

%package: is there one? check to ''cielo''
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'package'),
		package=options{i,2};
		found=1;
		break
	end
end
if ~found,
	disp('recover_solve_options info message: no ''package'' was provided, defaulting to ''cielo''');
	options(end+1,:)={'package' 'cielo'};
	package='cielo';
end
if ~ismemberi(package,{'cielo','ice','macayeal'}),
	error(['process_solve_options error message: package ' package ' not supported yet!']);
end

%analysis_type: check on this option, error out otherwise
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'analysis_type'),
		analysis_type=options{i,2};
		found=1;
		break
	end
end
if ~found,
	error('recover_solve_options error message: no ''analysis_type'' was provided');
end

%sub_analysis_type: check on it, not mandatory
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'sub_analysis_type'),
		sub_analysis_type=options{i,2};
		found=1;
		break
	end
end
if ~found
	sub_analysis_type='none';
end

%batch mode for launching jobs.
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'batch'),
		batch=options{i,2};
		found=1;
		break
	end
end
if ~found
	batch='no';
end

%check solution type is supported
if ~ismemberi(analysis_type,{'diagnostic','prognostic','thermal','steadystate','parameters','mesh2grid','transient'}),
	error(['process_solve_options error message: analysis_type ' analysis_type ' not supported yet!']);
else
	%convert to enum
	analysis_type=eval([upper(analysis_type(1)) lower(analysis_type(2:end)) 'AnalysisEnum']);
end
if ~ismemberi(sub_analysis_type,{'none','horiz','adjoint','gradient','inverse','vert',''}),
	error(['process_solve_options error message: sub_analysis_type ' sub_analysis_type ' not supported yet!']);
else
	%convert to enum
	sub_analysis_type=eval([upper(sub_analysis_type(1)) lower(sub_analysis_type(2:end)) 'AnalysisEnum']);
end

%  process qmu arguments

%first, the defaults
qmudir ='qmu';% qmudir =['qmu_' datestr(now,'yyyymmdd_HHMMSS')];
qmufile='qmu';%  qmufile can not be changed unless cielo_ice_script.sh is also changed
ivar   =1;
iresp  =1;
imethod=1;
iparams=1;
runmpi =false;

for i=1:size(options,1),
	switch options{i,1},
	case 'qmudir'
		qmudir=options{i,2};
	case 'qmufile'
		qmufile=options{i,2};
	case 'ivar'
		ivar=options{i,2};
	case 'iresp'
		iresp=options{i,2};
	case 'imethod'
		imethod=options{i,2};
	case 'iparams'
		iparams=options{i,2};
	case 'overwrite'
		outoptions.overwrite=options{i,2};
	case 'outfiles'
		outoptions.outfiles=options{i,2};
	case 'rstfile'
		outoptions.rstfile=options{i,2}; 
	case 'rundakota'
		outoptions.rundakota=options{i,2};
	case 'runmpi'
		runmpi=options{i,2};
	otherwise
		%nothing
	end
end

%setup final options structure
outoptions.analysis_type=analysis_type;
outoptions.package=package;
outoptions.sub_analysis_type=sub_analysis_type;
outoptions.qmudir=qmudir;
outoptions.qmufile=qmufile;
outoptions.ivar=ivar;
outoptions.iresp=iresp;
outoptions.imethod=imethod;
outoptions.iparams=iparams;
outoptions.runmpi=runmpi;
outoptions.batch=batch;
