/*!\file: CreateParameters.cpp
 * \brief general driver for creating parameters dataset
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParameters"

#include "../DataSet/DataSet.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "./Model.h"

void CreateParameters(DataSet** pparameters,Model* model,ConstDataHandle model_handle){
	
	int i;
	
	DataSet* parameters = NULL;
	Param*   param = NULL;
	int      count=1;
	int      analysis_type;
	int      numberofdofspernode;

	double* fit=NULL;
	double* optscal=NULL;
	double* maxiter=NULL; 
	double* control_parameter=NULL;
	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
	
	/*Initialize dataset: */
	parameters   = new DataSet(ParametersEnum());

	//Get analysis_type:
	analysis_type=AnalysisTypeAsEnum(model->analysis_type);
	
	count++;
	param= new Param(count,"analysis_type",INTEGER);
	param->SetInteger(analysis_type);
	parameters->AddObject(param);

	
	/*debug: */
	param= new Param(count,"debug",INTEGER);
	param->SetInteger(model->debug);
	parameters->AddObject(param);

	/*eps_rel: */
	count++;
	param= new Param(count,"eps_rel",DOUBLE);
	param->SetDouble(model->eps_rel);
	parameters->AddObject(param);

	/*eps_abs: */
	count++;
	param= new Param(count,"eps_abs",DOUBLE);
	param->SetDouble(model->eps_abs);
	parameters->AddObject(param);

	/*yts: */
	count++;
	param= new Param(count,"yts",DOUBLE);
	param->SetDouble(model->yts);
	parameters->AddObject(param);

	/*dt: */
	count++;
	param= new Param(count,"dt",DOUBLE);
	param->SetDouble(model->dt);
	parameters->AddObject(param);

	/*ndt: */
	count++;
	param= new Param(count,"ndt",DOUBLE);
	param->SetDouble(model->ndt);
	parameters->AddObject(param);

	/*penalty_offset: */
	count++;
	param= new Param(count,"penalty_offset",DOUBLE);
	param->SetDouble(model->penalty_offset);
	parameters->AddObject(param);

	/*sparsity: */
	count++;
	param= new Param(count,"sparsity",DOUBLE);
	param->SetDouble(model->sparsity);
	parameters->AddObject(param);

	/*lowmem: */
	count++;
	param= new Param(count,"lowmem",INTEGER);
	param->SetInteger(model->lowmem);
	parameters->AddObject(param);

	/*connectivity: */
	count++;
	param= new Param(count,"connectivity",INTEGER);
	param->SetInteger(model->connectivity);
	parameters->AddObject(param);

	/*beta: */
	count++;
	param= new Param(count,"beta",DOUBLE);
	param->SetDouble(model->beta);
	parameters->AddObject(param);

	/*meltingpoint: */
	count++;
	param= new Param(count,"meltingpoint",DOUBLE);
	param->SetDouble(model->meltingpoint);
	parameters->AddObject(param);

	/*latentheat: */
	count++;
	param= new Param(count,"latentheat",DOUBLE);
	param->SetDouble(model->latentheat);
	parameters->AddObject(param);

	/*heatcapacity: */
	count++;
	param= new Param(count,"heatcapacity",DOUBLE);
	param->SetDouble(model->heatcapacity);
	parameters->AddObject(param);

	/*penalty_melting: */
	count++;
	param= new Param(count,"penalty_melting",DOUBLE);
	param->SetDouble(model->penalty_melting);
	parameters->AddObject(param);

	/*min_thermal_constraints: */
	count++;
	param= new Param(count,"min_thermal_constraints",INTEGER);
	param->SetInteger(model->min_thermal_constraints);
	parameters->AddObject(param);

	/*waitonlock: */
	count++;
	param= new Param(count,"waitonlock",INTEGER);
	param->SetInteger(model->waitonlock);
	parameters->AddObject(param);

	/*solverstring: */
	count++;
	param= new Param(count,"solverstring",STRING);
	param->SetString(model->solverstring);
	parameters->AddObject(param);

	/*plot: */
	count++;
	param= new Param(count,"plot",INTEGER);
	param->SetInteger(model->plot);
	parameters->AddObject(param);

	/*numberofgrids: */
	count++;
	param= new Param(count,"numberofnodes",INTEGER);
	param->SetInteger(model->numberofnodes);
	parameters->AddObject(param);

	/*Deal with numberofdofspernode: */
	DistributeNumDofs(&numberofdofspernode,analysis_type);

	count++;
	param= new Param(count,"numberofdofspernode",INTEGER);
	param->SetInteger(numberofdofspernode);
	parameters->AddObject(param);

	/*Deal with control parameters: */
	if (analysis_type==ControlAnalysisEnum()){
		CreateParametersControl(parameters,model,model_handle,&count);
	}

	/*Diagnostic: */
	/*Get vx and vy: */
	ModelFetchData((void**)&vx,NULL,NULL,model_handle,"vx","Matrix","Mat");
	ModelFetchData((void**)&vy,NULL,NULL,model_handle,"vy","Matrix","Mat");
	ModelFetchData((void**)&vz,NULL,NULL,model_handle,"vz","Matrix","Mat");

	if(vx) for(i=0;i<model->numberofnodes;i++)vx[i]=vx[i]/model->yts;
	if(vy) for(i=0;i<model->numberofnodes;i++)vy[i]=vy[i]/model->yts;
	if(vz) for(i=0;i<model->numberofnodes;i++)vz[i]=vz[i]/model->yts;

	count++;
	param= new Param(count,"vx",DOUBLEVEC);
	if(vx) param->SetDoubleVec(vx,model->numberofnodes);
	else param->SetDoubleVec(vx,0);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"vy",DOUBLEVEC);
	if(vy) param->SetDoubleVec(vy,model->numberofnodes);
	else param->SetDoubleVec(vy,0);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"vz",DOUBLEVEC);
	if(vz) param->SetDoubleVec(vz,model->numberofnodes);
	else param->SetDoubleVec(vz,0);
	parameters->AddObject(param);

	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);

	/*All our datasets are already ordered by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	parameters->Presort();

	/*Assign output pointer: */
	*pparameters=parameters;
}
