/*!\file: CreateParametersControl.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParameters"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../Model.h"

void CreateParametersControl(DataSet* parameters,Model* model,ConstDataHandle model_handle,int* pcount){
	
	int i;
	
	Param*   param = NULL;
	int      count;
	int      analysis_type;
	int      numberofdofspernode;

	double* fit=NULL;
	double* optscal=NULL;
	double* maxiter=NULL; 
	double* control_parameter=NULL;
	double* vx_obs=NULL;
	double* vy_obs=NULL;

	/*Get counter : */
	count=*pcount;
	
	/*control_type: */
	count++;
	param= new Param(count,"control_type",STRING);
	param->SetString(model->control_type);
	parameters->AddObject(param);


	/*nsteps: */
	count++;
	param= new Param(count,"nsteps",INTEGER);
	param->SetInteger(model->nsteps);
	parameters->AddObject(param);

	/*tolx: */
	count++;
	param= new Param(count,"tolx",DOUBLE);
	param->SetDouble(model->tolx);
	parameters->AddObject(param);

	/*mincontrolconstraint: */
	count++;
	param= new Param(count,"mincontrolconstraint",DOUBLE);
	param->SetDouble(model->mincontrolconstraint);
	parameters->AddObject(param);

	/*maxcontrolconstraint: */
	count++;
	param= new Param(count,"maxcontrolconstraint",DOUBLE);
	param->SetDouble(model->maxcontrolconstraint);
	parameters->AddObject(param);
	
	/*epsvel: */
	count++;
	param= new Param(count,"epsvel",DOUBLE);
	param->SetDouble(model->epsvel);
	parameters->AddObject(param);
	
	/*meanvel: */
	count++;
	param= new Param(count,"meanvel",DOUBLE);
	param->SetDouble(model->meanvel);
	parameters->AddObject(param);

	/*Now, recover fit, optscal and maxiter as vectors: */
	ModelFetchData((void**)&model->fit,NULL,NULL,model_handle,"fit","Matrix","Mat");
	ModelFetchData((void**)&model->optscal,NULL,NULL,model_handle,"optscal","Matrix","Mat");
	ModelFetchData((void**)&model->maxiter,NULL,NULL,model_handle,"maxiter","Matrix","Mat");

	count++;
	param= new Param(count,"fit",DOUBLEVEC);
	param->SetDoubleVec(model->fit,model->nsteps);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"optscal",DOUBLEVEC);
	param->SetDoubleVec(model->optscal,model->nsteps);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"maxiter",DOUBLEVEC);
	param->SetDoubleVec(model->maxiter,model->nsteps);
	parameters->AddObject(param);

	xfree((void**)&model->fit);
	xfree((void**)&model->optscal);
	xfree((void**)&model->maxiter);

	/*Get vx_obs, vy_obs, and the parameter value: */
	ModelFetchData((void**)&vx_obs,NULL,NULL,model_handle,"vx_obs","Matrix","Mat");
	ModelFetchData((void**)&vy_obs,NULL,NULL,model_handle,"vy_obs","Matrix","Mat");
	ModelFetchData((void**)&control_parameter,NULL,NULL,model_handle,model->control_type,"Matrix","Mat");

	if(vx_obs)for(i=0;i<model->numberofnodes;i++)vx_obs[i]=vx_obs[i]/model->yts;
	if(vy_obs)for(i=0;i<model->numberofnodes;i++)vy_obs[i]=vy_obs[i]/model->yts;

	count++;
	param= new Param(count,"vx_obs",DOUBLEVEC);
	if(vx_obs) param->SetDoubleVec(vx_obs,model->numberofnodes);
	else param->SetDoubleVec(vx_obs,0);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"vy_obs",DOUBLEVEC);
	if(vy_obs) param->SetDoubleVec(vy_obs,model->numberofnodes);
	else param->SetDoubleVec(vy_obs,0);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"control_parameter",DOUBLEVEC);
	if(control_parameter) param->SetDoubleVec(control_parameter,model->numberofnodes);
	else param->SetDoubleVec(control_parameter,0);
	parameters->AddObject(param);


	xfree((void**)&vx_obs);
	xfree((void**)&vy_obs);
	xfree((void**)&control_parameter);


	/*Assign output pointer: */
	*pcount=count;
}

	
