%CALVINGDEV class definition
%
%   Usage:
%      calvingdev=calvingdev();

classdef calvingdev
	properties (SetAccess=public) 
		coeff         = NaN;
		meltingrate   = NaN;
	end
	methods
		function self = calvingdev(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				case 1
					inputstruct=varargin{1};
					list1 = properties('calvingdev');
					list2 = fieldnames(inputstruct);
					for i=1:length(list1)
						fieldname = list1{i};
						if ismember(fieldname,list2),
							self.(fieldname) = inputstruct.(fieldname);
						end
					end
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = extrude(self,md) % {{{
			self.coeff=project3d(md,'vector',self.coeff,'type','node');
			self.meltingrate=project3d(md,'vector',self.meltingrate,'type','node');
		end % }}}
		function self = setdefaultparameters(self) % {{{

			%Proportionality coefficient in Pi model
			self.coeff=2e13;
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{
			%Early return
			if (solution~=TransientSolutionEnum() | md.transient.ismovingfront==0), return; end

			md = checkfield(md,'fieldname','calving.coeff','>',0,'size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','calving.meltingrate','NaN',1,'Inf',1,'timeseries',1,'>=',0);
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   Calving Pi parameters:'));
			fielddisplay(self,'coeff','proportionality coefficient in Pi model');
			fielddisplay(self,'meltingrate','melting rate at given location [m/a]');

		end % }}}
		function marshall(self,prefix,md,fid) % {{{
			yts=md.constants.yts;
			WriteData(fid,prefix,'name','md.calving.law','data',2,'format','Integer');
			WriteData(fid,prefix,'object',self,'fieldname','coeff','format','DoubleMat','mattype',1);
			WriteData(fid,prefix,'object',self,'fieldname','meltingrate','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1,'scale',1./yts);
		end % }}}
	end
end
