/*\file StringToEnum.c
 *\brief:convert enum (int) to string
 */

#include "./StringToEnum.h"

void StringToEnumUsage(void){/*{{{*/
	_printf0_("\n");
	_printf0_("   usage: " << __FUNCT__ << "enum = StringToEnum(string);\n");
	_printf0_("\n");
}/*}}}*/
WRAPPER(StringToEnum_python){

	char *name = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments: */
	CHECKARGUMENTS(NLHS,NRHS,&StringToEnumUsage);

	/*Fetch inputs: */
	FetchData(&name,NAME);

	/*Run core function: */
	int enum_out=StringToEnumx(name);

	/* output: */
	WriteData(ENUMOUT,enum_out);

	/*end module: */
	xDelete<char>(name);
	MODULEEND();
}
