function segments=findsegments(md)
%FINDSEGMENTS - build segments model field
%
%   Usage:
%      segments=findsegments(md);

%Now, build the connectivity tables for this mesh.
if size(md.nodeconnectivity,1)~=md.numberofgrids,
	md.nodeconnectivity=NodeConnectivity(md.elements,md.numberofgrids);
end
if size(md.elementconnectivity,1)~=md.numberofelements,
	md.elementconnectivity=ElementConnectivity(md.elements,md.nodeconnectivity);
end

%Recreate the segments
elementconnectivity=md.elementconnectivity;
elementonboundary=double(elementconnectivity(:,end)==0);
pos=find(elementonboundary);
num_segments=length(pos);
segments=zeros(num_segments,3);
count=1;

for i=1:num_segments,
	el1=pos(i);
	els2=elementconnectivity(el1,find(elementconnectivity(el1,:)));
	if length(els2)>1,
		flag=intersect(md.elements(els2(1),:),md.elements(els2(2),:));
		nods1=md.elements(el1,:);
		nods1(find(nods1==flag))=[];
		segments(count,:)=[nods1 el1];

		ord1=find(nods1(1)==md.elements(el1,:));
		ord2=find(nods1(2)==md.elements(el1,:));

		%swap segment grids if necessary
		if ( (ord1==1 & ord2==2) | (ord1==2 & ord2==3) | (ord1==3 & ord2==1) ),
			temp=segments(count,1);
			segments(count,1)=segments(count,2);
			segments(count,2)=temp;
		end
		segments(count,1:2)=fliplr(segments(count,1:2));
		count=count+1;
	else
		nods1=md.elements(el1,:);
		flag=setdiff(nods1,md.elements(els2,:));
		for j=1:3,
			nods=nods1; nods(j)=[];
			if any(ismember(flag,nods)),
				segments(count,:)=[nods el1];
				ord1=find(nods(1)==md.elements(el1,:));
				ord2=find(nods(2)==md.elements(el1,:));
				if ( (ord1==1 & ord2==2) | (ord1==2 & ord2==3) | (ord1==3 & ord2==1) ),
					temp=segments(count,1);
					segments(count,1)=segments(count,2);
					segments(count,2)=temp;
				end
				segments(count,1:2)=fliplr(segments(count,1:2));
				count=count+1;
			end
		end
	end
end
